/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.util.Enumeration;
import java.util.Hashtable;
import jcifs.netbios.NameServicePacket;
import jcifs.netbios.NbtAddress;
import jcifs.netbios.SessionServicePacket;

public class Log
extends jcifs.util.Log {
    public static final int NONE = -241;
    public static final int ALL = 240;
    public static final int NAME_SERVICE_PACKET_DATA = 16;
    public static final int SESSION_SERVICE_PACKET_DATA = 32;
    public static final int ADDRESS_CACHE = 64;
    public static final int RESERVED8 = 128;

    Log() {
    }

    static void printPacketData(String desc, SessionServicePacket ssp) {
        try {
            if ((0x20 & jcifs.util.Log.mask) == 0) {
                return;
            }
            jcifs.util.Log.out.println(desc, ssp.toString());
        }
        catch (Exception e) {
            Log.printStackTrace("jcifs.netbios.Log.printPacketData()", e);
        }
    }

    static void printPacketData(String desc, NameServicePacket nsp) {
        try {
            if ((0x10 & jcifs.util.Log.mask) == 0) {
                return;
            }
            jcifs.util.Log.out.println(desc, nsp.toString());
        }
        catch (Exception e) {
            Log.printStackTrace("jcifs.netbios.Log.printPacketData()", e);
        }
    }

    static void printAddressCache(String desc, Hashtable addressCache) {
        if ((0x40 & jcifs.util.Log.mask) == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Enumeration e = addressCache.elements();
        while (e.hasMoreElements()) {
            NbtAddress.CacheEntry ce = (NbtAddress.CacheEntry)e.nextElement();
            sb.append(' ').append(ce.hostName);
            sb.append(' ').append(ce.address).append(jcifs.util.Log.NL);
        }
        jcifs.util.Log.out.println(desc, sb.toString());
    }
}

