/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import jcifs.Config;
import jcifs.netbios.Log;
import jcifs.netbios.Name;
import jcifs.netbios.NameServiceClient;

public final class NbtAddress {
    static final String ANY_HOSTS_NAME = "*\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    public static final String MASTER_BROWSER_NAME = "\u0001\u0002__MSBROWSE__\u0002";
    public static final String SMBSERVER_NAME = "*SMBSERVER     ";
    public static final int B_NODE = 0;
    public static final int P_NODE = 1;
    public static final int M_NODE = 2;
    public static final int H_NODE = 3;
    static final int DEFAULT_CACHE_POLICY = 30;
    static final int FOREVER = -1;
    static int cachePolicy;
    static Hashtable addressCache;
    static Hashtable lookupTable;
    static Name unknownName;
    static NbtAddress unknownAddress;
    static byte[] unknownMacAddress;
    static NameServiceClient client;
    static NbtAddress localhost;
    Name hostName;
    int address;
    int nodeType;
    boolean groupName;
    boolean isBeingDeleted;
    boolean isInConflict;
    boolean isActive;
    boolean isPermanent;
    boolean isDataFromNodeStatus;
    byte[] macAddress;
    String calledName;

    static void cacheAddress(Name hostName, NbtAddress addr) {
        if (cachePolicy == 0) {
            return;
        }
        long expiration = -1L;
        if (cachePolicy != -1) {
            expiration = System.currentTimeMillis() + (long)(cachePolicy * 1000);
        }
        NbtAddress.cacheAddress(hostName, addr, expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cacheAddress(Name hostName, NbtAddress addr, long expiration) {
        if (cachePolicy == 0) {
            return;
        }
        Hashtable hashtable = addressCache;
        synchronized (hashtable) {
            CacheEntry entry = (CacheEntry)addressCache.get(hostName);
            if (entry == null) {
                entry = new CacheEntry(hostName, addr, expiration);
                addressCache.put(hostName, entry);
            } else {
                entry.address = addr;
                entry.expiration = expiration;
            }
            Log.printAddressCache("name service address cache", addressCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cacheAddressArray(NbtAddress[] addrs) {
        if (cachePolicy == 0) {
            return;
        }
        long expiration = -1L;
        if (cachePolicy != -1) {
            expiration = System.currentTimeMillis() + (long)(cachePolicy * 1000);
        }
        Hashtable hashtable = addressCache;
        synchronized (hashtable) {
            int i = 0;
            while (i < addrs.length) {
                CacheEntry entry = (CacheEntry)addressCache.get(addrs[i].hostName);
                if (entry == null) {
                    entry = new CacheEntry(addrs[i].hostName, addrs[i], expiration);
                    addressCache.put(addrs[i].hostName, entry);
                } else {
                    entry.address = addrs[i];
                    entry.expiration = expiration;
                }
                ++i;
            }
            Log.printAddressCache("name service address cache", addressCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NbtAddress getCachedAddress(Name hostName) {
        if (cachePolicy == 0) {
            return null;
        }
        Hashtable hashtable = addressCache;
        synchronized (hashtable) {
            CacheEntry entry = (CacheEntry)addressCache.get(hostName);
            if (entry != null && entry.expiration < System.currentTimeMillis() && entry.expiration >= 0L) {
                entry = null;
            }
            return entry != null ? entry.address : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static NbtAddress doNameQuery(Name name, InetAddress svr) throws UnknownHostException {
        NbtAddress addr;
        block7: {
            if (name.hexCode == 29 && svr == null) {
                svr = NbtAddress.client.baddr;
            }
            name.srcHashCode = svr != null ? svr.hashCode() : 0;
            addr = NbtAddress.getCachedAddress(name);
            if (addr == null && (addr = (NbtAddress)NbtAddress.checkLookupTable(name)) == null) {
                try {
                    try {
                        addr = client.getByName(name, svr);
                    }
                    catch (UnknownHostException uhe) {
                        addr = unknownAddress;
                        Object var5_4 = null;
                        NbtAddress.cacheAddress(name, addr);
                        NbtAddress.updateLookupTable(name);
                        break block7;
                    }
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    NbtAddress.cacheAddress(name, addr);
                    NbtAddress.updateLookupTable(name);
                    throw throwable;
                }
                NbtAddress.cacheAddress(name, addr);
                NbtAddress.updateLookupTable(name);
            }
        }
        if (addr == unknownAddress) {
            throw new UnknownHostException(name.toString());
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static Object checkLookupTable(Name name) {
        var2_1 = NbtAddress.lookupTable;
        synchronized (var2_1) {
            if (NbtAddress.lookupTable.containsKey(name)) ** GOTO lbl13
            NbtAddress.lookupTable.put(name, name);
            return null;
lbl-1000:
            // 1 sources

            {
                try {
                    NbtAddress.lookupTable.wait();
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
lbl13:
                // 3 sources

                ** while (NbtAddress.lookupTable.containsKey((Object)name))
            }
lbl14:
            // 1 sources

        }
        obj = NbtAddress.getCachedAddress(name);
        if (obj == null) {
            var3_3 = NbtAddress.lookupTable;
            synchronized (var3_3) {
                NbtAddress.lookupTable.put(name, name);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLookupTable(Name name) {
        Hashtable hashtable = lookupTable;
        synchronized (hashtable) {
            lookupTable.remove(name);
            lookupTable.notifyAll();
        }
    }

    public static NbtAddress getLocalHost() throws UnknownHostException {
        return localhost;
    }

    public static NbtAddress getByName(String host) throws UnknownHostException {
        return NbtAddress.getByName(host, 0, null);
    }

    public static NbtAddress getByName(String host, int type, String scope) throws UnknownHostException {
        return NbtAddress.getByName(host, type, scope, null);
    }

    public static NbtAddress getByName(String host, int type, String scope, InetAddress svr) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            return NbtAddress.getLocalHost();
        }
        if (!Character.isDigit(host.charAt(0))) {
            return NbtAddress.doNameQuery(new Name(host, type, scope), svr);
        }
        int IP = 0;
        int hitDots = 0;
        char[] data = host.toCharArray();
        int i = 0;
        while (i < data.length) {
            char c = data[i];
            if (c < '0' || c > '9') {
                return NbtAddress.doNameQuery(new Name(host, type, scope), svr);
            }
            int b = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return NbtAddress.doNameQuery(new Name(host, type, scope), svr);
                }
                b = b * 10 + c - 48;
                if (++i >= data.length) break;
                c = data[i];
            }
            if (b > 255) {
                return NbtAddress.doNameQuery(new Name(host, type, scope), svr);
            }
            IP = (IP << 8) + b;
            ++hitDots;
            ++i;
        }
        if (hitDots != 4 || host.endsWith(".")) {
            return NbtAddress.doNameQuery(new Name(host, type, scope), svr);
        }
        return new NbtAddress(unknownName, IP, false, 0);
    }

    public static NbtAddress[] getAllByAddress(String host) throws UnknownHostException {
        return NbtAddress.getAllByAddress(NbtAddress.getByName(host, 0, null));
    }

    public static NbtAddress[] getAllByAddress(String host, int type, String scope) throws UnknownHostException {
        return NbtAddress.getAllByAddress(NbtAddress.getByName(host, type, scope));
    }

    public static NbtAddress[] getAllByAddress(NbtAddress addr) throws UnknownHostException {
        try {
            NbtAddress[] addrs = client.getNodeStatus(addr);
            NbtAddress.cacheAddressArray(addrs);
            return addrs;
        }
        catch (UnknownHostException uhe) {
            throw new UnknownHostException("no name with type 0x" + Name.toHexChars(addr.hostName.hexCode) + (addr.hostName.scope == null || addr.hostName.scope.length() == 0 ? " with no scope" : " with scope " + addr.hostName.scope) + " for host " + addr.getHostAddress());
        }
    }

    NbtAddress(Name hostName, int address, boolean groupName, int nodeType) {
        this.hostName = hostName;
        this.address = address;
        this.groupName = groupName;
        this.nodeType = nodeType;
    }

    NbtAddress(Name hostName, int address, boolean groupName, int nodeType, boolean isBeingDeleted, boolean isInConflict, boolean isActive, boolean isPermanent, byte[] macAddress) {
        this.hostName = hostName;
        this.address = address;
        this.groupName = groupName;
        this.nodeType = nodeType;
        this.isBeingDeleted = isBeingDeleted;
        this.isInConflict = isInConflict;
        this.isActive = isActive;
        this.isPermanent = isPermanent;
        this.macAddress = macAddress;
        this.isDataFromNodeStatus = true;
    }

    public String firstCalledName() {
        this.calledName = this.hostName.name;
        if (Character.isDigit(this.calledName.charAt(0))) {
            int dots = 0;
            int i = 0;
            int len = this.calledName.length();
            char[] data = this.calledName.toCharArray();
            while (i < len && Character.isDigit(data[i++])) {
                if (i == len && dots == 3) {
                    this.calledName = SMBSERVER_NAME;
                    break;
                }
                if (i >= len || data[i] != '.') continue;
                ++dots;
                ++i;
            }
        } else if (this.hostName.hexCode == 29) {
            this.calledName = SMBSERVER_NAME;
        }
        return this.calledName;
    }

    public String nextCalledName() {
        if (this.calledName == this.hostName.name) {
            this.calledName = SMBSERVER_NAME;
        } else if (this.calledName == SMBSERVER_NAME) {
            try {
                NbtAddress[] addrs = client.getNodeStatus(this);
                if (this.hostName.hexCode == 29) {
                    int i = 0;
                    while (i < addrs.length) {
                        if (addrs[i].hostName.hexCode == 32) {
                            return addrs[i].hostName.name;
                        }
                        ++i;
                    }
                    return null;
                }
                if (this.isDataFromNodeStatus) {
                    this.calledName = null;
                    return this.hostName.name;
                }
            }
            catch (UnknownHostException uhe) {
                this.calledName = null;
            }
        } else {
            this.calledName = null;
        }
        return this.calledName;
    }

    void checkData() throws UnknownHostException {
        if (this.hostName == unknownName) {
            NbtAddress.getAllByAddress(this);
        }
    }

    void checkNodeStatusData() throws UnknownHostException {
        if (!this.isDataFromNodeStatus) {
            NbtAddress.getAllByAddress(this);
        }
    }

    public boolean isGroupAddress() throws UnknownHostException {
        this.checkData();
        return this.groupName;
    }

    public int getNodeType() throws UnknownHostException {
        this.checkData();
        return this.nodeType;
    }

    public boolean isBeingDeleted() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.isBeingDeleted;
    }

    public boolean isInConflict() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.isInConflict;
    }

    public boolean isActive() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.isActive;
    }

    public boolean isPermanent() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.isPermanent;
    }

    public byte[] getMacAddress() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.macAddress;
    }

    public String getHostName() {
        try {
            this.checkData();
        }
        catch (UnknownHostException uhe) {
            return this.getHostAddress();
        }
        return this.hostName.name;
    }

    public byte[] getAddress() {
        byte[] addr = new byte[]{(byte)(this.address >>> 24 & 0xFF), (byte)(this.address >>> 16 & 0xFF), (byte)(this.address >>> 8 & 0xFF), (byte)(this.address & 0xFF)};
        return addr;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.getHostAddress());
    }

    public String getHostAddress() {
        return (this.address >>> 24 & 0xFF) + "." + (this.address >>> 16 & 0xFF) + "." + (this.address >>> 8 & 0xFF) + "." + (this.address >>> 0 & 0xFF);
    }

    public int getNameType() {
        return this.hostName.hexCode;
    }

    public int hashCode() {
        return this.address;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof NbtAddress && ((NbtAddress)obj).address == this.address;
    }

    public String toString() {
        return this.hostName.toString() + "/" + this.getHostAddress();
    }

    static {
        String localHostname;
        unknownMacAddress = new byte[]{0, 0, 0, 0, 0, 0};
        addressCache = new Hashtable();
        lookupTable = new Hashtable();
        cachePolicy = Config.getInt("jcifs.netbios.cachePolicy", 30);
        client = new NameServiceClient();
        unknownName = new Name("0.0.0.0", 0, null);
        unknownAddress = new NbtAddress(unknownName, 0, false, 0);
        addressCache.put(unknownName, new CacheEntry(unknownName, unknownAddress, -1L));
        InetAddress localInetAddress = NbtAddress.client.laddr;
        if (localInetAddress == null) {
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
        }
        if ((localHostname = Config.getProperty("jcifs.netbios.hostname", null)) == null || localHostname.length() == 0) {
            byte[] addr = localInetAddress.getAddress();
            localHostname = "JCIFS" + (addr[2] & 0xFF) + "_" + (addr[3] & 0xFF) + "_" + Name.toHexChars((int)(Math.random() * 255.0));
        }
        Name localName = new Name(localHostname, 0, Config.getProperty("jcifs.netbios.scope", null));
        localhost = new NbtAddress(localName, localInetAddress.hashCode(), false, 0, false, false, true, false, unknownMacAddress);
        NbtAddress.cacheAddress(localName, localhost, -1L);
    }

    static final class CacheEntry {
        Name hostName;
        NbtAddress address;
        long expiration;

        CacheEntry(Name hostName, NbtAddress address, long expiration) {
            this.hostName = hostName;
            this.address = address;
            this.expiration = expiration;
        }
    }
}

