/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp;

import jcifs.Config;
import jcifs.ntlmssp.NtlmFlags;

public abstract class NtlmMessage
implements NtlmFlags {
    protected static final byte[] NTLMSSP_SIGNATURE = new byte[]{78, 84, 76, 77, 83, 83, 80, 0};
    private static final String OEM_ENCODING = Config.getProperty("jcifs.smb.client.codepage", Config.getProperty("jcifs.encoding", System.getProperty("file.encoding")));
    private int flags;

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean getFlag(int flag) {
        return (this.getFlags() & flag) != 0;
    }

    public void setFlag(int flag, boolean value) {
        this.setFlags(value ? this.getFlags() | flag : this.getFlags() & (0xFFFFFFFF ^ flag));
    }

    static int readULong(byte[] src, int index) {
        return src[index] & 0xFF | (src[index + 1] & 0xFF) << 8 | (src[index + 2] & 0xFF) << 16 | (src[index + 3] & 0xFF) << 24;
    }

    static int readUShort(byte[] src, int index) {
        return src[index] & 0xFF | (src[index + 1] & 0xFF) << 8;
    }

    static byte[] readSecurityBuffer(byte[] src, int index) {
        int length = NtlmMessage.readUShort(src, index);
        int offset = NtlmMessage.readULong(src, index + 4);
        byte[] buffer = new byte[length];
        System.arraycopy(src, offset, buffer, 0, length);
        return buffer;
    }

    static void writeULong(byte[] dest, int offset, int ulong) {
        dest[offset] = (byte)(ulong & 0xFF);
        dest[offset + 1] = (byte)(ulong >> 8 & 0xFF);
        dest[offset + 2] = (byte)(ulong >> 16 & 0xFF);
        dest[offset + 3] = (byte)(ulong >> 24 & 0xFF);
    }

    static void writeUShort(byte[] dest, int offset, int ushort) {
        dest[offset] = (byte)(ushort & 0xFF);
        dest[offset + 1] = (byte)(ushort >> 8 & 0xFF);
    }

    static void writeSecurityBuffer(byte[] dest, int offset, int bodyOffset, byte[] src) {
        int length;
        int n = length = src != null ? src.length : 0;
        if (length == 0) {
            return;
        }
        NtlmMessage.writeUShort(dest, offset, length);
        NtlmMessage.writeUShort(dest, offset + 2, length);
        NtlmMessage.writeULong(dest, offset + 4, bodyOffset);
        System.arraycopy(src, 0, dest, bodyOffset, length);
    }

    static String getOEMEncoding() {
        return OEM_ENCODING;
    }

    public abstract byte[] toByteArray();
}

