/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.FileEntry;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.util.Log;

class NetShareEnumResponse
extends SmbComTransactionResponse {
    int converter;
    int totalAvailableEntries;

    NetShareEnumResponse() {
    }

    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        this.status = ServerMessageBlock.readInt2(buffer, bufferIndex);
        this.converter = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
        this.numEntries = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
        this.totalAvailableEntries = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
        return (bufferIndex += 2) - start;
    }

    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        this.useUnicode = false;
        this.results = new ShareInfo1[this.numEntries];
        int i = 0;
        while (i < this.numEntries) {
            ShareInfo1 e = new ShareInfo1();
            this.results[i] = e;
            e.netName = this.readString(buffer, bufferIndex, 13, false);
            e.type = ServerMessageBlock.readInt2(buffer, bufferIndex += 14);
            int off = ServerMessageBlock.readInt4(buffer, bufferIndex += 2);
            bufferIndex += 4;
            off = (off & 0xFFFF) - this.converter;
            off = start + off;
            e.remark = this.readString(buffer, off, 128, false);
            Log.println(2, "smb warning", e);
            ++i;
        }
        return bufferIndex - start;
    }

    public String toString() {
        return new String("NetShareEnumResponse[" + super.toString() + ",status=" + this.status + ",converter=" + this.converter + ",entriesReturned=" + this.numEntries + ",totalAvailableEntries=" + this.totalAvailableEntries + "]");
    }

    class ShareInfo1
    implements FileEntry {
        String netName;
        int type;
        String remark;

        ShareInfo1() {
        }

        public String getName() {
            return this.netName;
        }

        public int getType() {
            switch (this.type) {
                case 1: {
                    return 32;
                }
                case 3: {
                    return 16;
                }
            }
            return 8;
        }

        public int getAttributes() {
            return 17;
        }

        public long createTime() {
            return 0L;
        }

        public long lastModified() {
            return 0L;
        }

        public long length() {
            return 0L;
        }

        public String toString() {
            return new String("ShareInfo1[netName=" + this.netName + ",type=0x" + Log.getHexString(this.type, 4) + ",remark=" + this.remark + "]");
        }
    }
}

