/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import jcifs.smb.Log;
import jcifs.smb.ServerMessageBlock;

class SmbComNegotiateResponse
extends ServerMessageBlock {
    int dialectIndex;
    int securityMode;
    int security;
    int maxMpxCount;
    int maxNumberVcs;
    int maxBufferSize;
    int maxRawSize;
    int sessionKey;
    int capabilities;
    int serverTimeZone;
    int encryptionKeyLength;
    boolean encryptedPasswords;
    boolean signaturesEnabled;
    boolean signaturesRequired;
    long serverTime;
    byte[] encryptionKey;
    String oemDomainName;

    SmbComNegotiateResponse() {
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.dialectIndex = ServerMessageBlock.readInt2(buffer, bufferIndex);
        bufferIndex += 2;
        if (this.dialectIndex > 10) {
            return bufferIndex - start;
        }
        this.securityMode = buffer[bufferIndex++] & 0xFF;
        this.security = this.securityMode & 1;
        this.encryptedPasswords = (this.securityMode & 2) == 2;
        this.signaturesEnabled = (this.securityMode & 4) == 4;
        this.signaturesRequired = (this.securityMode & 8) == 8;
        this.maxMpxCount = ServerMessageBlock.readInt2(buffer, bufferIndex);
        this.maxNumberVcs = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
        this.maxBufferSize = ServerMessageBlock.readInt4(buffer, bufferIndex += 2);
        this.maxRawSize = ServerMessageBlock.readInt4(buffer, bufferIndex += 4);
        this.sessionKey = ServerMessageBlock.readInt4(buffer, bufferIndex += 4);
        this.capabilities = ServerMessageBlock.readInt4(buffer, bufferIndex += 4);
        this.serverTime = ServerMessageBlock.readTime(buffer, bufferIndex += 4);
        this.serverTimeZone = ServerMessageBlock.readInt2(buffer, bufferIndex += 8);
        bufferIndex += 2;
        this.encryptionKeyLength = buffer[bufferIndex++] & 0xFF;
        return bufferIndex - start;
    }

    /*
     * Unable to fully structure code
     */
    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        block8: {
            block6: {
                block7: {
                    start = bufferIndex;
                    this.encryptionKey = new byte[this.encryptionKeyLength];
                    System.arraycopy(buffer, bufferIndex, this.encryptionKey, 0, this.encryptionKeyLength);
                    bufferIndex += this.encryptionKeyLength;
                    if (this.byteCount <= this.encryptionKeyLength) break block6;
                    len = 0;
                    if ((this.flags2 & 32768) != 32768) ** GOTO lbl19
                    while (buffer[bufferIndex + len] != 0 || buffer[bufferIndex + len + 1] != 0) {
                        if ((len += 2) <= 256) continue;
                        throw new RuntimeException("zero termination not found");
                    }
                    try {
                        this.oemDomainName = new String(buffer, bufferIndex, len, "UnicodeLittle");
                    }
                    catch (UnsupportedEncodingException uee) {
                        Log.printStackTrace("smb exception", uee);
                    }
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        if (++len <= 256) continue;
                        throw new RuntimeException("zero termination not found");
lbl19:
                        // 2 sources

                        ** while (buffer[bufferIndex + len] != 0)
                    }
lbl20:
                    // 1 sources

                    try {
                        this.oemDomainName = new String(buffer, bufferIndex, len, ServerMessageBlock.encoding);
                    }
                    catch (UnsupportedEncodingException uee) {
                        // empty catch block
                    }
                }
                bufferIndex += len;
                break block8;
            }
            this.oemDomainName = new String();
        }
        return bufferIndex - start;
    }

    public String toString() {
        return new String("SmbComNegotiateResponse[" + super.toString() + ",wordCount=" + this.wordCount + ",dialectIndex=" + this.dialectIndex + ",securityMode=0x" + Log.getHexString(this.securityMode, 1) + ",security=" + (this.security == 0 ? "share" : "user") + ",encryptedPasswords=" + this.encryptedPasswords + ",maxMpxCount=" + this.maxMpxCount + ",maxNumberVcs=" + this.maxNumberVcs + ",maxBufferSize=" + this.maxBufferSize + ",maxRawSize=" + this.maxRawSize + ",sessionKey=0x" + jcifs.util.Log.getHexString(this.sessionKey, 8) + ",capabilities=0x" + jcifs.util.Log.getHexString(this.capabilities, 8) + ",serverTime=" + new Date(this.serverTime) + ",serverTimeZone=" + this.serverTimeZone + ",encryptionKeyLength=" + this.encryptionKeyLength + ",byteCount=" + this.byteCount + ",encryptionKey=0x" + Log.getHexString(this.encryptionKey, 0, this.encryptionKeyLength * 2) + ",oemDomainName=" + this.oemDomainName + "]");
    }
}

