/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Date;
import jcifs.smb.Info;
import jcifs.smb.Log;
import jcifs.smb.ServerMessageBlock;

class SmbComQueryInformationResponse
extends ServerMessageBlock
implements Info {
    int fileAttributes = 0;
    long lastWriteTime = 0L;
    long serverTimeZoneOffset;
    int fileSize = 0;

    SmbComQueryInformationResponse(long serverTimeZoneOffset) {
        this.serverTimeZoneOffset = serverTimeZoneOffset;
        this.command = (byte)8;
    }

    public int getAttributes() {
        return this.fileAttributes;
    }

    public long getCreateTime() {
        return this.lastWriteTime + this.serverTimeZoneOffset;
    }

    public long getLastWriteTime() {
        return this.lastWriteTime + this.serverTimeZoneOffset;
    }

    public long getSize() {
        return this.fileSize;
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        if (this.wordCount == 0) {
            return 0;
        }
        this.fileAttributes = ServerMessageBlock.readInt2(buffer, bufferIndex);
        this.lastWriteTime = ServerMessageBlock.readUTime(buffer, bufferIndex += 2);
        this.fileSize = ServerMessageBlock.readInt4(buffer, bufferIndex += 4);
        return 20;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    public String toString() {
        return new String("SmbComQueryInformationResponse[" + super.toString() + ",fileAttributes=0x" + Log.getHexString(this.fileAttributes, 4) + ",lastWriteTime=" + new Date(this.lastWriteTime) + ",fileSize=" + this.fileSize + "]");
    }
}

