/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import jcifs.Config;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbSession;

class SmbComSessionSetupAndX
extends AndXServerMessageBlock {
    static final int BATCH_LIMIT = Config.getInt("jcifs.smb.client.SessionSetupAndX.TreeConnectAndX", 1);
    byte[] accountPassword;
    byte[] unicodePassword;
    int passwordLength;
    int unicodePasswordLength;
    int negotiatedMaxBufferSize;
    int negotiatedMaxMpxCount;
    int vcNumber;
    int sessionKey;
    String accountName;
    String primaryDomain;
    String nativeOs;
    String nativeLanMan;
    SmbSession session;

    SmbComSessionSetupAndX(SmbSession session, ServerMessageBlock andx) {
        super(andx);
        this.command = (byte)115;
        this.session = session;
    }

    int getBatchLimit(byte command) {
        return command == 117 ? BATCH_LIMIT : 0;
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (this.session.transport.server.security == 1 && (this.session.auth.hashesExternal || this.session.auth.password.length() > 0)) {
            if (this.session.transport.server.encryptedPasswords) {
                this.accountPassword = this.session.auth.getAnsiHash(this.session.transport.server.encryptionKey);
                this.unicodePassword = this.session.auth.getUnicodeHash(this.session.transport.server.encryptionKey);
                this.unicodePasswordLength = 24;
                this.passwordLength = 24;
                if (this.unicodePassword.length == 0) {
                    this.unicodePasswordLength = 0;
                }
            } else {
                if (Config.getBoolean("jcifs.smb.client.disablePlainTextPasswords", true)) {
                    throw new RuntimeException("Plain text passwords are disabled");
                }
                if (this.useUnicode) {
                    String password = this.session.auth.getPassword();
                    this.accountPassword = new byte[0];
                    this.passwordLength = 0;
                    this.unicodePassword = new byte[(password.length() + 1) * 2];
                    this.unicodePasswordLength = this.writeString(password, this.unicodePassword, 0);
                } else {
                    String password = this.session.auth.getPassword();
                    this.accountPassword = new byte[(password.length() + 1) * 2];
                    this.passwordLength = this.writeString(password, this.accountPassword, 0);
                    this.unicodePassword = new byte[0];
                    this.unicodePasswordLength = 0;
                }
            }
        } else {
            this.unicodePasswordLength = 0;
            this.passwordLength = 0;
        }
        this.negotiatedMaxBufferSize = this.session.transport.negotiatedMaxBufferSize;
        this.negotiatedMaxMpxCount = this.session.transport.negotiatedMaxMpxCount;
        this.vcNumber = this.session.transport.client.vcNumber;
        this.sessionKey = this.session.transport.client.sessionKey;
        ServerMessageBlock.writeInt2(this.negotiatedMaxBufferSize, dst, dstIndex);
        ServerMessageBlock.writeInt2(this.negotiatedMaxMpxCount, dst, dstIndex += 2);
        ServerMessageBlock.writeInt2(this.vcNumber, dst, dstIndex += 2);
        ServerMessageBlock.writeInt4(this.sessionKey, dst, dstIndex += 2);
        ServerMessageBlock.writeInt2(this.passwordLength, dst, dstIndex += 4);
        ServerMessageBlock.writeInt2(this.unicodePasswordLength, dst, dstIndex += 2);
        dstIndex += 2;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        ServerMessageBlock.writeInt4(this.session.transport.client.capabilities, dst, dstIndex);
        return (dstIndex += 4) - start;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        this.accountName = this.session.auth.username.toUpperCase();
        this.primaryDomain = this.session.auth.domain.toUpperCase();
        this.nativeOs = this.session.transport.client.nativeOs;
        this.nativeLanMan = this.session.transport.client.nativeLanMan;
        if (this.session.transport.server.security == 1 && (this.session.auth.hashesExternal || this.session.auth.password.length() > 0)) {
            System.arraycopy(this.accountPassword, 0, dst, dstIndex, this.passwordLength);
            System.arraycopy(this.unicodePassword, 0, dst, dstIndex += this.passwordLength, this.unicodePasswordLength);
            dstIndex += this.unicodePasswordLength;
        }
        if (this.useUnicode) {
            dst[dstIndex++] = 0;
        }
        dstIndex += this.writeString(this.accountName, dst, dstIndex);
        dstIndex += this.writeString(this.primaryDomain, dst, dstIndex);
        dstIndex += this.writeString(this.nativeOs, dst, dstIndex);
        dstIndex += this.writeString(this.nativeLanMan, dst, dstIndex);
        return dstIndex - start;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesDirectWireFormat(InputStream in, int byteCount) throws IOException {
        return 0;
    }

    public String toString() {
        String result = new String("SmbComSessionSetupAndX[" + super.toString() + ",maxBufferSize=" + this.negotiatedMaxBufferSize + ",maxMpxCount=" + this.negotiatedMaxMpxCount + ",vcNumber=" + this.vcNumber + ",sessionKey=" + this.sessionKey + ",passwordLength=" + this.passwordLength + ",unicodePasswordLength=" + this.unicodePasswordLength + ",capabilities=" + this.session.transport.client.capabilities + ",accountName=" + this.accountName + ",primaryDomain=" + this.primaryDomain + ",nativeOs=" + this.nativeOs + ",nativeLanMan=" + this.nativeLanMan + "]");
        return result;
    }
}

