/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.Config;
import jcifs.smb.Log;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbComTransaction;

class Trans2FindFirst2
extends SmbComTransaction {
    static final int SMB_INFO_STANDARD = 1;
    static final int SMB_INFO_QUERY_EA_SIZE = 2;
    static final int SMB_INFO_QUERY_EAS_FROM_LIST = 3;
    static final int SMB_FIND_FILE_DIRECTORY_INFO = 257;
    static final int SMB_FIND_FILE_FULL_DIRECTORY_INFO = 258;
    static final int SMB_FILE_NAMES_INFO = 259;
    static final int SMB_FILE_BOTH_DIRECTORY_INFO = 260;
    static final int FLAGS_CLOSE_AFTER_THIS_REQUEST = 1;
    static final int FLAGS_CLOSE_IF_END_REACHED = 2;
    static final int FLAGS_RETURN_RESUME_KEYS = 4;
    static final int FLAGS_RESUME_FROM_PREVIOUS_END = 8;
    static final int FLAGS_FIND_WITH_BACKUP_INTENT = 16;
    static final int DEFAULT_MAX_DATA_COUNT = 1200;
    static final int DEFAULT_SEARCH_COUNT = 15;
    int searchAttributes;
    int searchCount;
    int flags;
    int informationLevel;
    int searchStorageType = 0;
    String wildcard;

    Trans2FindFirst2(String filename, String wildcard, int searchAttributes) {
        this.path = filename.equals("\\") ? filename : filename + "\\";
        this.wildcard = wildcard;
        this.searchAttributes = searchAttributes & 0x3F;
        this.command = (byte)50;
        this.subCommand = 1;
        this.searchCount = Config.getInt("jcifs.smb.client.listCount", 15);
        this.flags = 0;
        this.informationLevel = 260;
        this.totalDataCount = 0;
        this.maxParameterCount = 10;
        this.maxDataCount = Config.getInt("jcifs.smb.client.listSize", 1200);
        this.maxSetupCount = 0;
    }

    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex++] = this.subCommand;
        dst[dstIndex++] = 0;
        return 2;
    }

    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        ServerMessageBlock.writeInt2(this.searchAttributes, dst, dstIndex);
        ServerMessageBlock.writeInt2(this.searchCount, dst, dstIndex += 2);
        ServerMessageBlock.writeInt2(this.flags, dst, dstIndex += 2);
        ServerMessageBlock.writeInt2(this.informationLevel, dst, dstIndex += 2);
        ServerMessageBlock.writeInt4(this.searchStorageType, dst, dstIndex += 2);
        dstIndex += 4;
        dstIndex += this.writeString(this.path + this.wildcard, dst, dstIndex);
        return dstIndex - start;
    }

    int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    public String toString() {
        return new String("Trans2FindFirst2[" + super.toString() + ",searchAttributes=0x" + Log.getHexString(this.searchAttributes, 2) + ",searchCount=" + this.searchCount + ",flags=0x" + Log.getHexString(this.flags, 2) + ",informationLevel=0x" + Log.getHexString(this.informationLevel, 3) + ",searchStorageType=" + this.searchStorageType + ",filename=" + this.path + "]");
    }
}

