/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.Config;
import jcifs.smb.Log;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbComTransaction;

class Trans2FindNext2
extends SmbComTransaction {
    int sid;
    int searchCount;
    int informationLevel;
    int resumeKey;
    int flags;
    String filename;

    Trans2FindNext2(int sid, int resumeKey, String filename) {
        this.sid = sid;
        this.resumeKey = resumeKey;
        this.filename = filename;
        this.command = (byte)50;
        this.subCommand = (byte)2;
        this.searchCount = Config.getInt("jcifs.smb.client.listCount", 15);
        this.informationLevel = 260;
        this.flags = 0;
        this.maxParameterCount = 8;
        this.maxDataCount = Config.getInt("jcifs.smb.client.listSize", 1200);
        this.maxSetupCount = 0;
    }

    public void reset(int resumeKey, String lastName) {
        super.reset();
        this.resumeKey = resumeKey;
        this.filename = lastName;
        this.flags2 = 0;
    }

    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex++] = this.subCommand;
        dst[dstIndex++] = 0;
        return 2;
    }

    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        ServerMessageBlock.writeInt2(this.sid, dst, dstIndex);
        ServerMessageBlock.writeInt2(this.searchCount, dst, dstIndex += 2);
        ServerMessageBlock.writeInt2(this.informationLevel, dst, dstIndex += 2);
        ServerMessageBlock.writeInt4(this.resumeKey, dst, dstIndex += 2);
        ServerMessageBlock.writeInt2(this.flags, dst, dstIndex += 4);
        dstIndex += 2;
        dstIndex += this.writeString(this.filename, dst, dstIndex);
        return dstIndex - start;
    }

    int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    public String toString() {
        return new String("Trans2FindNext2[" + super.toString() + ",sid=" + this.sid + ",searchCount=" + this.searchCount + ",informationLevel=0x" + Log.getHexString(this.informationLevel, 3) + ",resumeKey=0x" + Log.getHexString(this.resumeKey, 4) + ",flags=0x" + Log.getHexString(this.flags, 2) + ",filename=" + this.filename + "]");
    }
}

