/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.OutputStream;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.TransCallNamedPipe;
import jcifs.smb.TransCallNamedPipeResponse;
import jcifs.smb.TransTransactNamedPipe;
import jcifs.smb.TransTransactNamedPipeResponse;
import jcifs.smb.TransWaitNamedPipe;
import jcifs.smb.TransWaitNamedPipeResponse;

class TransactNamedPipeOutputStream
extends OutputStream {
    String path;
    SmbNamedPipe pipe;
    byte[] tmp = new byte[1];

    TransactNamedPipeOutputStream(SmbNamedPipe pipe) throws IOException {
        this.pipe = pipe;
        this.path = pipe.unc;
    }

    public void close() throws IOException {
        this.pipe.close();
    }

    public void write(int b) throws IOException {
        this.tmp[0] = (byte)b;
        this.write(this.tmp, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            len = 0;
        }
        if ((this.pipe.pipeType & 1) == 1) {
            this.pipe.sendTransaction(new TransWaitNamedPipe(this.path), new TransWaitNamedPipeResponse());
            this.pipe.sendTransaction(new TransCallNamedPipe(this.path, b, off, len), new TransCallNamedPipeResponse(this.pipe));
        } else if ((this.pipe.pipeType & 2) == 2) {
            this.pipe.open(this.pipe.pipeType & 0xFF0000 | 1, 128, 0);
            this.pipe.sendTransaction(new TransTransactNamedPipe(this.pipe.fid, b, off, len), new TransTransactNamedPipeResponse(this.pipe));
        }
    }
}

