/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import jcifs.util.Log;
import jcifs.util.PropertiesTree;

public class Config {
    protected static PropertiesTree properties = new PropertiesTree();

    Config() {
    }

    public static void load(InputStream in) throws IOException {
        if (in != null) {
            properties.load(in);
        }
        Properties sys = System.getProperties();
        Enumeration<?> e = sys.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = sys.getProperty(key);
            if (key == null || val == null) continue;
            try {
                properties.put(key, val);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
    }

    public static void list(PrintStream out) throws IOException {
        properties.list(out);
    }

    public static String setProperty(String key, String value) {
        return (String)properties.put(key, value);
    }

    public static Object get(String key) {
        return properties.get(key);
    }

    public static String getProperty(String key, String def) {
        String result = null;
        Object obj = Config.get(key);
        if (obj != null && obj instanceof String) {
            result = (String)obj;
        }
        return obj == null ? def : result;
    }

    public static String getProperty(String key) {
        String result = null;
        Object obj = Config.get(key);
        if (obj != null && obj instanceof String) {
            result = (String)obj;
        }
        return result;
    }

    public static int getInt(String key, int def) {
        block2: {
            Object obj = Config.get(key);
            if (obj == null || !(obj instanceof String)) break block2;
            try {
                def = Integer.parseInt((String)obj);
            }
            catch (NumberFormatException nfe) {
                Log.printStackTrace("configuration warning", nfe);
            }
        }
        return def;
    }

    public static int getInt(String key) {
        int result;
        block2: {
            result = -1;
            Object obj = Config.get(key);
            if (obj == null || !(obj instanceof String)) break block2;
            try {
                result = Integer.parseInt((String)obj);
            }
            catch (NumberFormatException nfe) {
                Log.printStackTrace("configuration warning", nfe);
            }
        }
        return result;
    }

    public static long getLong(String key, long def) {
        block2: {
            Object obj = Config.get(key);
            if (obj == null || !(obj instanceof String)) break block2;
            try {
                def = Long.parseLong((String)obj);
            }
            catch (NumberFormatException nfe) {
                Log.printStackTrace("configuration warning", nfe);
            }
        }
        return def;
    }

    public static InetAddress getInetAddress(String key, InetAddress def) {
        block2: {
            String addr = Config.getProperty(key);
            if (addr == null) break block2;
            try {
                def = InetAddress.getByName(addr);
            }
            catch (UnknownHostException uhe) {}
        }
        return def;
    }

    public static boolean getBoolean(String key, boolean def) {
        String b = Config.getProperty(key);
        if (b != null) {
            def = b.toLowerCase().equals("true");
        }
        return def;
    }

    public static void printProperties(String msg) {
        Log.printProperties(2, msg, properties);
    }
}

