/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs;

import java.net.URL;
import java.util.List;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;

public interface FileObject {
    public FileName getName();

    public URL getURL() throws FileSystemException;

    public boolean exists() throws FileSystemException;

    public boolean isHidden() throws FileSystemException;

    public boolean isReadable() throws FileSystemException;

    public boolean isWriteable() throws FileSystemException;

    public FileType getType() throws FileSystemException;

    public FileObject getParent() throws FileSystemException;

    public FileSystem getFileSystem();

    public FileObject[] getChildren() throws FileSystemException;

    public FileObject getChild(String var1) throws FileSystemException;

    public FileObject resolveFile(String var1, NameScope var2) throws FileSystemException;

    public FileObject resolveFile(String var1) throws FileSystemException;

    public FileObject[] findFiles(FileSelector var1) throws FileSystemException;

    public void findFiles(FileSelector var1, boolean var2, List var3) throws FileSystemException;

    public boolean delete() throws FileSystemException;

    public int delete(FileSelector var1) throws FileSystemException;

    public void createFolder() throws FileSystemException;

    public void createFile() throws FileSystemException;

    public void copyFrom(FileObject var1, FileSelector var2) throws FileSystemException;

    public void moveTo(FileObject var1) throws FileSystemException;

    public boolean canRenameTo(FileObject var1);

    public FileContent getContent() throws FileSystemException;

    public void close() throws FileSystemException;
}

