/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.impl.VirtualFileName;
import org.apache.commons.vfs.impl.VirtualFileSystem;
import org.apache.commons.vfs.provider.AbstractVfsContainer;

public class VirtualFileProvider
extends AbstractVfsContainer {
    public FileObject createFileSystem(FileObject rootFile) throws FileSystemException {
        FileName rootName = this.getContext().getFileSystemManager().resolveName(rootFile.getName(), "/");
        VirtualFileSystem fs = new VirtualFileSystem(rootName, null);
        this.addComponent(fs);
        fs.addJunction("/", rootFile);
        return fs.getRoot();
    }

    public FileObject createFileSystem(String rootUri) throws FileSystemException {
        VirtualFileName rootName = new VirtualFileName(rootUri, "/", FileType.FOLDER);
        VirtualFileSystem fs = new VirtualFileSystem(rootName, null);
        this.addComponent(fs);
        return fs.getRoot();
    }
}

