/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs.provider.sftp.SftpRandomAccessContent;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.commons.vfs.util.RandomAccessMode;

public class SftpFileObject
extends AbstractFileObject
implements FileObject {
    private final SftpFileSystem fileSystem;
    private SftpATTRS attrs;
    private final String relPath;

    protected SftpFileObject(FileName name, SftpFileSystem fileSystem) throws FileSystemException {
        super(name, fileSystem);
        this.fileSystem = fileSystem;
        this.relPath = UriParser.decode(fileSystem.getRootName().getRelativeName(name));
    }

    protected FileType doGetType() throws Exception {
        if (this.attrs == null) {
            this.statSelf();
        }
        if (this.attrs == null) {
            return FileType.IMAGINARY;
        }
        if ((this.attrs.getFlags() & 4) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-permissions.error");
        }
        if (this.attrs.isDir()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected void onChange() throws Exception {
        this.statSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statSelf() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            this.setStat(channel.stat(this.relPath));
        }
        catch (SftpException e) {
            this.attrs = null;
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    private void setStat(SftpATTRS attrs) {
        this.attrs = attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            channel.mkdir(this.relPath);
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 8) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-modtime.error");
        }
        return (long)this.attrs.getMTime() * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetLastModifiedTime(long modtime) throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            int newMTime = (int)(modtime / 1000L);
            this.attrs.setACMODTIME(this.attrs.getATime(), newMTime);
            channel.setStat(this.relPath, this.attrs);
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            if (this.getType() == FileType.FILE) {
                channel.rm(this.relPath);
            } else {
                channel.rmdir(this.relPath);
            }
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject newfile) throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            channel.rename(this.relPath, ((SftpFileObject)newfile).relPath);
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject[] doListChildrenResolved() throws Exception {
        Vector vector;
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            vector = channel.ls(this.relPath);
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
        if (vector == null) {
            throw new FileSystemException("vfs.provider.sftp/list-children.error");
        }
        ArrayList<SftpFileObject> children = new ArrayList<SftpFileObject>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ChannelSftp.LsEntry stat = (ChannelSftp.LsEntry)iterator.next();
            String name = stat.getFilename();
            if (VFS.isUriStyle() && stat.getAttrs().isDir() && name.charAt(name.length() - 1) != '/') {
                name = name + "/";
            }
            if (name.equals(".") || name.equals("..") || name.equals("./") || name.equals("../")) continue;
            SftpFileObject fo = (SftpFileObject)this.getFileSystem().resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.getName(), UriParser.encode(name), NameScope.CHILD));
            fo.setStat(stat.getAttrs());
            children.add(fo);
        }
        return children.toArray(new SftpFileObject[children.size()]);
    }

    protected String[] doListChildren() throws Exception {
        return null;
    }

    protected long doGetContentSize() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 1) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-size.error");
        }
        return this.attrs.getSize();
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new SftpRandomAccessContent(this, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getInputStream(long filePointer) throws IOException {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            ByteArrayOutputStream outstr = new ByteArrayOutputStream();
            try {
                channel.get(this.getName().getPathDecoded(), (OutputStream)outstr, null, 1, filePointer);
            }
            catch (SftpException e) {
                throw new FileSystemException(e);
            }
            outstr.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outstr.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream doGetInputStream() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            ByteArrayOutputStream outstr = new ByteArrayOutputStream();
            channel.get(this.relPath, (OutputStream)outstr);
            outstr.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outstr.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        return new SftpOutputStream(channel);
    }

    private class SftpOutputStream
    extends MonitorOutputStream {
        private final ChannelSftp channel;

        public SftpOutputStream(ChannelSftp channel) {
            super(new ByteArrayOutputStream());
            this.channel = channel;
        }

        protected void onClose() throws IOException {
            try {
                ByteArrayOutputStream outstr = (ByteArrayOutputStream)this.out;
                this.channel.put((InputStream)new ByteArrayInputStream(outstr.toByteArray()), SftpFileObject.this.relPath);
            }
            catch (SftpException e) {
                throw new FileSystemException(e);
            }
            finally {
                SftpFileObject.this.fileSystem.putChannel(this.channel);
            }
        }
    }
}

