/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.tasks;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.tasks.CopyTask;

public class MoveTask
extends CopyTask {
    private boolean tryRename = false;

    public void setTryRename(boolean tryRename) {
        this.tryRename = tryRename;
    }

    protected void handleOutOfDateFile(FileObject srcFile, FileObject destFile) throws FileSystemException {
        if (!this.tryRename || !srcFile.canRenameTo(destFile)) {
            super.handleOutOfDateFile(srcFile, destFile);
            this.log("Deleting " + srcFile);
            srcFile.delete(Selectors.SELECT_SELF);
        } else {
            this.log("Rename " + srcFile + " to " + destFile);
            srcFile.moveTo(destFile);
            if (!this.isPreserveLastModified()) {
                destFile.getContent().setLastModifiedTime(System.currentTimeMillis());
            }
        }
    }
}

