/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.NamingContainerUtil;
import javax.faces.internal.SavedState;

public class ComponentStates {
    private Map savedStates = new HashMap();

    public void restoreDescendantState(FacesContext context, UIComponent component) {
        Iterator it = component.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            NamingContainerUtil.refreshClientId(child);
            if (child instanceof EditableValueHolder) {
                EditableValueHolder holder = (EditableValueHolder)((Object)child);
                String clientId = child.getClientId(context);
                SavedState state = (SavedState)this.savedStates.get(clientId);
                if (state == null) {
                    state = new SavedState();
                    this.savedStates.put(clientId, state);
                }
                state.restore(holder);
            }
            this.restoreDescendantState(context, child);
        }
    }

    public void saveDescendantComponentStates(FacesContext context, UIComponent component) {
        Iterator it = component.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (child instanceof EditableValueHolder) {
                EditableValueHolder holder = (EditableValueHolder)((Object)child);
                SavedState state = new SavedState();
                state.save(holder);
                this.savedStates.put(child.getClientId(context), state);
            }
            this.saveDescendantComponentStates(context, child);
        }
    }

    public void clear() {
        this.savedStates.clear();
    }
}

