/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class ValidatorChain
implements Validator,
StateHolder {
    private boolean transientValue = false;
    private List validators = new LinkedList();

    public int getValidatorSize() {
        return this.validators.size();
    }

    public Validator getValidator(int index) {
        return (Validator)this.validators.get(index);
    }

    public void add(Validator validator) {
        this.validators.add(validator);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value == null) {
            return;
        }
        Iterator iterator = this.validators.iterator();
        while (iterator.hasNext()) {
            Validator validator = (Validator)iterator.next();
            validator.validate(context, component, value);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[this.validators.size() + 1];
        for (int i = 0; i < this.validators.size(); ++i) {
            Object validator = this.validators.get(i);
            values[i] = validator instanceof StateHolder ? ((StateHolder)validator).saveState(context) : null;
        }
        values[values.length - 1] = this.validators;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.validators = (List)values[values.length - 1];
        for (int i = 0; i < this.validators.size(); ++i) {
            Object validator = this.validators.get(i);
            if (!(validator instanceof StateHolder)) continue;
            ((StateHolder)validator).restoreState(context, values[i]);
        }
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }
}

