/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.impl;

import java.io.InputStream;
import java.util.LinkedList;
import javax.faces.internal.FacesConfigOptions;
import org.seasar.framework.container.factory.ResourceResolver;
import org.seasar.framework.container.factory.WebResourceResolver;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.xml.SaxHandlerParser;
import org.seasar.teeda.core.config.faces.AbstractFacesConfigurator;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.impl.FacesConfigUtil;

public class ConfigFilesFacesConfigurator
extends AbstractFacesConfigurator {
    private static final Logger logger_ = Logger.getLogger((Class)ConfigFilesFacesConfigurator.class);
    private static final String FACES_CONFIG_DELIMETER = ",";

    public ConfigFilesFacesConfigurator() {
        this.setResourceResolver((ResourceResolver)new WebResourceResolver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacesConfig configure() {
        LinkedList<Object> configs = new LinkedList<Object>();
        String path = this.getPath();
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("target file path = " + path));
        }
        if (path == null) {
            return null;
        }
        String[] paths = StringUtil.split((String)path, (String)FACES_CONFIG_DELIMETER);
        for (int i = 0; i < paths.length; ++i) {
            String targetPath = paths[i];
            SaxHandlerParser parser = this.createSaxHandlerParser();
            InputStream is = this.resourceResolver_.getInputStream(targetPath.trim());
            try {
                configs.add(parser.parse(is));
                continue;
            }
            finally {
                InputStreamUtil.close((InputStream)is);
            }
        }
        return FacesConfigUtil.collectAllFacesConfig(configs);
    }

    public String getPath() {
        return FacesConfigOptions.getConfigFiles();
    }
}

