/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.portlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.teeda.core.config.faces.FacesConfigBuilder;
import org.seasar.teeda.core.config.faces.assembler.AssemblerAssembler;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.webapp.WebappConfigBuilder;
import org.seasar.teeda.core.config.webapp.element.WebappConfig;
import org.seasar.teeda.core.context.portlet.PortletExternalContextImpl;
import org.seasar.teeda.core.context.portlet.PortletFacesContextImpl;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.FacesContextUtil;

public class FacesPortlet
extends GenericPortlet {
    private static final Log log = LogFactory.getLog((Class)FacesPortlet.class);
    public static final String VIEW_ID = FacesPortlet.class.getName() + ".VIEW_ID";
    protected static final String CURRENT_FACES_CONTEXT = FacesPortlet.class.getName() + ".CURRENT_FACES_CONTEXT";
    public final String DEFULT_VIEW_PAGE = "view-page";
    public final String DEFULT_EDIT_PAGE = "edit-page";
    public final String DEFULT_HELP_PAGE = "help-page";
    protected static final String FACES_INIT_DONE = FacesPortlet.class.getName() + ".FACES_INIT_DONE";
    protected FacesContextFactory facesContextFactory;
    protected Lifecycle lifecycle;
    private String defaultViewPage = null;
    private String defaultEditPage = null;
    private String defaultHelpPage = null;

    public void init() throws PortletException {
        super.init();
        this.initializeFaces(this.getPortletContext());
        this.defaultViewPage = this.getPortletConfig().getInitParameter("view-page");
        this.defaultEditPage = this.getPortletConfig().getInitParameter("edit-page");
        this.defaultHelpPage = this.getPortletConfig().getInitParameter("help-page");
        if (null == this.defaultViewPage) {
            throw new PortletException("Portlet " + this.getPortletConfig().getPortletName() + " is incorrectly configured. No default View page is defined.");
        }
        if (null == this.defaultEditPage) {
            this.defaultEditPage = this.defaultViewPage;
        }
        if (null == this.defaultHelpPage) {
            this.defaultHelpPage = this.defaultViewPage;
        }
        this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        this.lifecycle = lifecycleFactory.getLifecycle(FacesConfigOptions.getLifecycleId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeFaces(PortletContext servletContext) {
        boolean isAlreadyInitialized;
        Boolean b = (Boolean)servletContext.getAttribute(FACES_INIT_DONE);
        boolean bl = isAlreadyInitialized = b != null ? b : false;
        if (!isAlreadyInitialized) {
            this.initializeFacesConfigOptions(servletContext);
            FacesConfigBuilder facesConfigBuilder = (FacesConfigBuilder)DIContainerUtil.getComponent(FacesConfigBuilder.class);
            FacesConfig facesConfig = facesConfigBuilder.createFacesConfigs();
            AssemblerAssembler assembler = (AssemblerAssembler)DIContainerUtil.getComponent(AssemblerAssembler.class);
            assembler.assembleFactories(facesConfig);
            assembler.assembleApplication(facesConfig);
            assembler.assembleManagedBeans(facesConfig);
            assembler.assmbleNavigationRules(facesConfig);
            assembler.assembleLifecycle(facesConfig);
            assembler.assembleRenderKits(facesConfig);
            WebappConfigBuilder webAppConfigBuilder = (WebappConfigBuilder)DIContainerUtil.getComponent(WebappConfigBuilder.class);
            InputStream is = null;
            WebappConfig webappConfig = null;
            try {
                is = servletContext.getResourceAsStream("/WEB-INF/web.xml");
                webappConfig = webAppConfigBuilder.build(is);
            }
            finally {
                InputStreamUtil.close((InputStream)is);
            }
            servletContext.setAttribute(WebappConfig.class.getName(), (Object)webappConfig);
            servletContext.setAttribute(FACES_INIT_DONE, (Object)Boolean.TRUE);
        }
    }

    protected void initializeFacesConfigOptions(PortletContext servletContext) {
        String suffix;
        FacesConfigOptions.setConfigFiles(servletContext.getInitParameter("javax.faces.CONFIG_FILES"));
        String savingMethod = servletContext.getInitParameter("javax.faces.STATE_SAVING_METHOD");
        if (savingMethod != null) {
            FacesConfigOptions.setSavingStateInClient("client".equalsIgnoreCase(savingMethod));
        }
        if ((suffix = servletContext.getInitParameter("javax.faces.DEFAULT_SUFFIX")) != null) {
            FacesConfigOptions.setDefaultSuffix(suffix);
        } else {
            FacesConfigOptions.setDefaultSuffix(".jsp");
        }
        String lifecycleId = servletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (lifecycleId != null) {
            FacesConfigOptions.setLifecycleId(lifecycleId);
        } else {
            FacesConfigOptions.setLifecycleId("DEFAULT");
        }
    }

    public void destroy() {
        super.destroy();
        FactoryFinder.releaseFactories();
    }

    protected void setContentType(RenderRequest request, RenderResponse response) {
        if (response.getContentType() == null) {
            String portalPreferredContentType = request.getResponseContentType();
            if (portalPreferredContentType != null) {
                response.setContentType(portalPreferredContentType);
            } else {
                response.setContentType("text/html");
            }
        }
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setContentType(request, response);
        this.facesRender(request, response, this.defaultEditPage);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setContentType(request, response);
        this.facesRender(request, response, this.defaultHelpPage);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setContentType(request, response);
        this.facesRender(request, response, this.defaultViewPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void facesRender(RenderRequest request, RenderResponse response, String page) throws PortletException, IOException {
        String viewId;
        if (log.isDebugEnabled()) {
            log.debug((Object)"called facesRender(RenderRequest, RenderResponse, String).");
        }
        if ((viewId = request.getParameter(VIEW_ID)) == null || this.sessionTimedOut((PortletRequest)request)) {
            this.nonFacesRequest(request, response, page);
            this.storeResponseCharacterEncoding(request);
            return;
        }
        PortletFacesContextImpl facesContext = (PortletFacesContextImpl)request.getPortletSession().getAttribute(CURRENT_FACES_CONTEXT);
        if (facesContext == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("facesContext is null.  viewId=" + viewId));
            }
            this.nonFacesRequest(request, response, page);
            this.storeResponseCharacterEncoding(request);
            return;
        }
        try {
            if (facesContext.getResponseComplete()) {
                return;
            }
            facesContext.setExternalContext(new PortletExternalContextImpl(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response));
            this.lifecycle.render(facesContext);
            this.storeResponseCharacterEncoding(request);
            request.getPortletSession().removeAttribute(CURRENT_FACES_CONTEXT);
        }
        catch (Throwable e) {
            this.handleExceptionFromLifecycle(e);
        }
        finally {
            facesContext.release();
        }
    }

    protected void nonFacesRequest(RenderRequest request, RenderResponse response, String view) throws PortletException {
        FacesContext facesContext = this.facesContextFactory.getFacesContext(this.getPortletContext(), request, response, this.lifecycle);
        ViewHandler viewHandler = FacesContextUtil.getViewHandler(facesContext);
        UIViewRoot viewRoot = viewHandler.restoreView(facesContext, view);
        if (viewRoot == null) {
            viewRoot = viewHandler.createView(facesContext, view);
        }
        facesContext.setViewRoot(viewRoot);
        this.initializeChildren(facesContext, viewRoot);
        this.lifecycle.render(facesContext);
        facesContext.release();
    }

    protected void storeResponseCharacterEncoding(RenderRequest request) {
        String characterEncoding = request.getParameter("javax.faces.request.charset");
        if (characterEncoding != null) {
            request.getPortletSession().setAttribute("javax.faces.request.charset", (Object)characterEncoding);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"called processAction(ActionRequest, ActionResponse).");
        }
        if (this.sessionTimedOut((PortletRequest)request)) {
            return;
        }
        FacesContext facesContext = this.facesContextFactory.getFacesContext(this.getPortletContext(), request, response, this.lifecycle);
        try {
            this.lifecycle.execute(facesContext);
            if (!facesContext.getResponseComplete()) {
                response.setRenderParameter(VIEW_ID, facesContext.getViewRoot().getViewId());
            }
            response.setRenderParameter("javax.faces.request.charset", request.getCharacterEncoding());
            request.getPortletSession().setAttribute(CURRENT_FACES_CONTEXT, (Object)facesContext);
        }
        catch (Throwable e) {
            facesContext.release();
            this.handleExceptionFromLifecycle(e);
        }
    }

    protected void handleExceptionFromLifecycle(Throwable e) throws PortletException, IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof PortletException) {
            throw (PortletException)e;
        }
        if (e.getMessage() != null) {
            throw new PortletException(e.getMessage(), e);
        }
        throw new PortletException(e);
    }

    protected boolean sessionTimedOut(PortletRequest request) {
        return request.getPortletSession(false) == null;
    }

    protected void initializeChildren(FacesContext context, UIComponent component) {
        Iterator i = component.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            if (child instanceof EditableValueHolder) {
                EditableValueHolder editableValueHolder = (EditableValueHolder)((Object)child);
                editableValueHolder.setValid(true);
                editableValueHolder.setSubmittedValue(null);
                editableValueHolder.setValue(null);
                editableValueHolder.setLocalValueSet(false);
            }
            this.initializeChildren(context, child);
        }
    }
}

