/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.teeda.core.render.html.AbstractHtmlRenderer;
import org.seasar.teeda.core.util.FacesContextUtil;
import org.seasar.teeda.core.util.HtmlFormRendererUtil;
import org.seasar.teeda.core.util.RendererUtil;

public class HtmlFormRenderer
extends AbstractHtmlRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Form";
    public static final String RENDERER_TYPE = "javax.faces.Form";
    private static final String HIDDEN_PARAMETER_KEY = HtmlFormRenderer.class.getName() + ".HIDDEN_PARAMETER_KEY";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlFormBegin(context, (HtmlForm)component);
    }

    protected void encodeHtmlFormBegin(FacesContext context, HtmlForm htmlForm) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("form", htmlForm);
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlForm, this.getIdForRender(context, htmlForm));
        RendererUtil.renderAttribute(writer, "name", (Object)htmlForm.getClientId(context));
        RendererUtil.renderAttribute(writer, "method", (Object)"post");
        this.renderAttributes(htmlForm, writer);
        ViewHandler viewHandler = FacesContextUtil.getViewHandler(context);
        String viewId = context.getViewRoot().getViewId();
        String url = viewHandler.getActionURL(context, viewId);
        if (url != null) {
            writer.writeURIAttribute("action", context.getExternalContext().encodeActionURL(url), null);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        context.getApplication().getViewHandler().writeState(context);
        this.encodeHtmlFormEnd(context, (HtmlForm)component);
    }

    protected void encodeHtmlFormEnd(FacesContext context, HtmlForm htmlForm) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.renderFormSubmitMarker(context, htmlForm, writer);
        this.renderForCommandLink(context, htmlForm, writer);
        writer.endElement("form");
    }

    protected void renderForCommandLink(FacesContext context, HtmlForm htmlForm, ResponseWriter writer) throws IOException {
        Iterator it = HtmlFormRenderer.getHiddenParameters(htmlForm).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            this.renderHidden(htmlForm, writer, name, value);
        }
        htmlForm.getAttributes().remove(HIDDEN_PARAMETER_KEY);
    }

    private void renderHidden(HtmlForm htmlForm, ResponseWriter writer, String name, Object value) throws IOException {
        writer.startElement("input", htmlForm);
        RendererUtil.renderAttribute(writer, "type", (Object)"hidden");
        RendererUtil.renderAttribute(writer, "name", (Object)name);
        RendererUtil.renderAttribute(writer, "value", value);
        writer.endElement("input");
    }

    public static void setHiddenParameter(UIForm form, String name, Object value) {
        Map map = HtmlFormRenderer.getHiddenParameters(form);
        map.put(name, value);
    }

    public static Map getHiddenParameters(UIForm form) {
        Map attributes = form.getAttributes();
        LinkedHashMap map = (LinkedHashMap)attributes.get(HIDDEN_PARAMETER_KEY);
        if (map == null) {
            map = new LinkedHashMap();
            attributes.put(HIDDEN_PARAMETER_KEY, map);
        }
        return map;
    }

    private void renderFormSubmitMarker(FacesContext context, HtmlForm htmlForm, ResponseWriter writer) throws IOException {
        String clientId = htmlForm.getClientId(context);
        String key = HtmlFormRendererUtil.getFormSubmitKey(context, htmlForm);
        this.renderHidden(htmlForm, writer, key, clientId);
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeHtmlForm(context, (HtmlForm)component);
    }

    protected void decodeHtmlForm(FacesContext context, HtmlForm htmlForm) {
        String key;
        Map reqParam = context.getExternalContext().getRequestParameterMap();
        if (reqParam.containsKey(key = HtmlFormRendererUtil.getFormSubmitKey(context, htmlForm))) {
            htmlForm.setSubmitted(true);
        } else {
            htmlForm.setSubmitted(false);
        }
    }
}

