/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.teeda.core.render.html.AbstractHtmlRenderer;
import org.seasar.teeda.core.util.DecodeUtil;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlInputTextareaRenderer
extends AbstractHtmlRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String RENDERER_TYPE = "javax.faces.Textarea";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlInputTextareaEnd(context, (HtmlInputTextarea)component);
    }

    protected void encodeHtmlInputTextareaEnd(FacesContext context, HtmlInputTextarea htmlInputTextarea) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("textarea", htmlInputTextarea);
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlInputTextarea, this.getIdForRender(context, htmlInputTextarea));
        RendererUtil.renderAttribute(writer, "name", (Object)htmlInputTextarea.getClientId(context));
        this.renderAttributes(htmlInputTextarea, writer);
        String value = ValueHolderUtil.getValueForRender(context, htmlInputTextarea);
        writer.writeText(value, null);
        writer.endElement("textarea");
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeHtmlInputText(context, (HtmlInputTextarea)component);
    }

    protected void decodeHtmlInputText(FacesContext context, HtmlInputTextarea htmlInputTextarea) {
        DecodeUtil.decode(context, htmlInputTextarea);
    }
}

