/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.teeda.core.render.html.AbstractHtmlRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlOutputLabelRenderer
extends AbstractHtmlRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Output";
    public static final String RENDERER_TYPE = "javax.faces.Label";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlOutputLabelBegin(context, (HtmlOutputLabel)component);
    }

    protected void encodeHtmlOutputLabelBegin(FacesContext context, HtmlOutputLabel htmlOutputLabel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("label", htmlOutputLabel);
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlOutputLabel, this.getIdForRender(context, htmlOutputLabel));
        String forAttr = htmlOutputLabel.getFor();
        if (forAttr != null) {
            UIComponent forComponent = htmlOutputLabel.findComponent(forAttr);
            if (forComponent == null) {
                throw new IllegalStateException("for Component [" + forAttr + "] does not found");
            }
            String forClientId = forComponent.getClientId(context);
            RendererUtil.renderAttribute(writer, "for", forClientId, null);
        }
        this.renderAttributes(htmlOutputLabel, writer);
        String value = ValueHolderUtil.getValueForRender(context, htmlOutputLabel);
        writer.writeText(value, null);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlOutputLabelEnd(context, (HtmlOutputLabel)component);
    }

    protected void encodeHtmlOutputLabelEnd(FacesContext context, HtmlOutputLabel htmlOutputLabel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("label");
    }
}

