/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.teeda.core.render.html.AbstractHtmlRenderer;
import org.seasar.teeda.core.render.html.support.UrlBuilder;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlOutputLinkRenderer
extends AbstractHtmlRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Output";
    public static final String RENDERER_TYPE = "javax.faces.Link";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlOutputLinkBegin(context, (HtmlOutputLink)component);
    }

    protected void encodeHtmlOutputLinkBegin(FacesContext context, HtmlOutputLink htmlOutputLink) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase(ValueHolderUtil.getValueForRender(context, htmlOutputLink));
        String encoding = writer.getCharacterEncoding();
        Iterator it = htmlOutputLink.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            urlBuilder.add(URLEncoder.encode(parameter.getName(), encoding), URLEncoder.encode(parameter.getValue().toString(), encoding));
        }
        String href = context.getExternalContext().encodeResourceURL(urlBuilder.build());
        writer.startElement("a", htmlOutputLink);
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlOutputLink, this.getIdForRender(context, htmlOutputLink));
        writer.writeURIAttribute("href", href, null);
        this.renderAttributes(htmlOutputLink, writer);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlOutputLinkEnd(context, (HtmlOutputLink)component);
    }

    protected void encodeHtmlOutputLinkEnd(FacesContext context, HtmlOutputLink link) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("a");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

