/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.html.support.UrlParameter;
import org.seasar.teeda.core.util.ArrayUtil;

public class UrlString {
    private Map parameters = new LinkedHashMap();
    private String path;
    private String queryString;

    public void parse(String url) {
        if (StringUtil.contains((String)url, (char)'?')) {
            int questionPos = url.indexOf(63);
            this.path = url.substring(0, questionPos);
            this.queryString = url.substring(questionPos + 1);
        } else {
            this.path = url;
        }
        String[] params = StringUtil.split((String)this.queryString, (String)"&");
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            if (!StringUtil.contains((String)param, (char)'=')) continue;
            String key = param.substring(0, param.indexOf(61));
            UrlParameter urlParameter = (UrlParameter)this.parameters.get(key);
            if (urlParameter == null) {
                urlParameter = new UrlParameter();
                urlParameter.setKey(key);
                this.parameters.put(urlParameter.getKey(), urlParameter);
            }
            urlParameter.addValue(param.substring(param.indexOf(61) + 1));
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getParameter(String key) {
        UrlParameter param = (UrlParameter)this.parameters.get(key);
        if (param == null) {
            return null;
        }
        return param.getValue();
    }

    public String[] getParameters(String key) {
        UrlParameter param = (UrlParameter)this.parameters.get(key);
        if (param == null) {
            return null;
        }
        return param.getValues();
    }

    public boolean isIdentical(UrlString otherUrl) {
        if (!this.getPath().equals(otherUrl.getPath())) {
            return false;
        }
        Set myParamNames = this.getParameterNames();
        Set otherParamNames = otherUrl.getParameterNames();
        if (myParamNames.size() != otherParamNames.size()) {
            return false;
        }
        Iterator it = myParamNames.iterator();
        while (it.hasNext()) {
            Object[] otherValues;
            String key = (String)it.next();
            Object[] myValues = this.getParameters(key);
            if (ArrayUtil.equalsIgnoreSequence(myValues, otherValues = otherUrl.getParameters(key))) continue;
            return false;
        }
        return true;
    }

    public Set getParameterNames() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }
}

