/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.internal.ValueBindingUtil;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.AssertionUtil;

public class LoadBundleTag
extends TagSupport {
    private static Logger logger = Logger.getLogger((Class)LoadBundleTag.class);
    private static final long serialVersionUID = 1L;
    private String basename;
    private String var;

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getBasename() {
        return this.basename;
    }

    public String getVar() {
        return this.var;
    }

    public int doStartTag() throws JspException {
        ResourceBundle bundle;
        FacesContext context = FacesContext.getCurrentInstance();
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        UIViewRoot viewRoot = context.getViewRoot();
        AssertionUtil.assertNotNull((String)"ViewRoot", (Object)viewRoot);
        Locale locale = viewRoot.getLocale();
        if (locale == null) {
            locale = context.getApplication().getDefaultLocale();
        }
        String bname = null;
        String basename = this.getBasename();
        if (basename != null) {
            if (UIComponentTag.isValueReference(basename)) {
                ValueBinding vb = ValueBindingUtil.createValueBinding(context, basename);
                bname = (String)vb.getValue(context);
            } else {
                bname = basename;
            }
        }
        try {
            bundle = ResourceBundle.getBundle(bname, locale, Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException e) {
            logger.error((Object)("Resource bundle '" + bname + "' could not be found"));
            return 0;
        }
        context.getExternalContext().getRequestMap().put(this.var, new BundleMap(bundle));
        return 0;
    }

    public void release() {
        this.basename = null;
        this.var = null;
    }

    private static class BundleMap
    implements Map {
        private ResourceBundle bundle;
        private List values;

        public BundleMap(ResourceBundle bundle) {
            this.bundle = bundle;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            boolean result = false;
            if (key != null) {
                result = this.bundle.getObject(key.toString()) != null;
            }
            return result;
        }

        public int hashCode() {
            return this.bundle.hashCode();
        }

        public boolean isEmpty() {
            boolean result = true;
            Enumeration<String> keys = this.bundle.getKeys();
            result = !keys.hasMoreElements();
            return result;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new ArrayList();
                Enumeration<String> keys = this.bundle.getKeys();
                while (keys.hasMoreElements()) {
                    this.values.add(this.bundle.getString(keys.nextElement()));
                }
            }
            return this.values;
        }

        public int size() {
            return this.values().size();
        }

        public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        public Set entrySet() {
            HashMap<String, Object> mappings = new HashMap<String, Object>();
            Enumeration<String> keys = this.bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Object value = this.bundle.getObject(key);
                mappings.put(key, value);
            }
            return mappings.entrySet();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Map)) {
                return false;
            }
            return ((Object)this.entrySet()).equals(((Map)obj).entrySet());
        }

        public Object get(Object key) {
            if (key == null) {
                return null;
            }
            Object result = null;
            try {
                result = this.bundle.getObject(key.toString());
            }
            catch (MissingResourceException e) {
                result = "???" + key + "???";
            }
            return result;
        }

        public Set keySet() {
            HashSet<String> set = new HashSet<String>();
            Enumeration<String> enumer = this.bundle.getKeys();
            while (enumer.hasMoreElements()) {
                set.add(enumer.nextElement());
            }
            return set;
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

