/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.ValueBindingUtil;
import javax.faces.webapp.UIComponentBodyTag;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.tagext.BodyContent;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.LocaleUtil;

public class ViewTag
extends UIComponentBodyTag {
    private static final String COMPONENT_TYPE = "javax.faces.ViewRoot";
    protected String locale = null;

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getComponentType() {
        return COMPONENT_TYPE;
    }

    public String getRendererType() {
        return null;
    }

    public int doStartTag() throws JspException {
        int rc = 0;
        rc = super.doStartTag();
        FacesContext context = FacesContext.getCurrentInstance();
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        this.pageContext.getResponse().setLocale(context.getViewRoot().getLocale());
        ResponseWriter writer = context.getResponseWriter();
        AssertionUtil.assertNotNull((String)"ResponseWriter", (Object)writer);
        try {
            writer.startDocument();
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return rc;
    }

    public int doAfterBody() throws JspException {
        BodyContent bodyContent = null;
        String content = null;
        FacesContext context = FacesContext.getCurrentInstance();
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        ResponseWriter responseWriter = context.getResponseWriter();
        StateManager stateManager = context.getApplication().getStateManager();
        StateManager.SerializedView view = null;
        int beginIndex = 0;
        int markerIndex = 0;
        int markerLen = "org.seasar.teeda.core.STATE_MARKER".length();
        int contentLen = 0;
        responseWriter = responseWriter.cloneWithWriter((Writer)this.getPreviousOut());
        context.setResponseWriter(responseWriter);
        bodyContent = this.getBodyContent();
        if (bodyContent == null) {
            throw new JspException("BodyContent is null for tag with handler class:" + this.getClass().getName());
        }
        content = bodyContent.getString();
        try {
            view = stateManager.saveSerializedView(context);
        }
        catch (IllegalStateException ise) {
            throw new JspException((Throwable)ise);
        }
        catch (Exception e) {
            throw new JspException("Error while saving state in session:" + e.getMessage(), (Throwable)e);
        }
        try {
            if (view == null) {
                this.getPreviousOut().write(content);
            } else {
                contentLen = content.length();
                do {
                    if ((markerIndex = content.indexOf("org.seasar.teeda.core.STATE_MARKER", beginIndex)) == -1) {
                        responseWriter.write(content.substring(beginIndex));
                        continue;
                    }
                    responseWriter.write(content.substring(beginIndex, markerIndex));
                    stateManager.writeState(context, view);
                    beginIndex = markerIndex + markerLen;
                } while (-1 != markerIndex && beginIndex < contentLen);
            }
        }
        catch (IOException ioe) {
            throw new JspException("Error while saving state in client:" + ioe.getMessage(), (Throwable)ioe);
        }
        return 6;
    }

    public int doEndTag() throws JspException {
        int rc = super.doEndTag();
        FacesContext context = FacesContext.getCurrentInstance();
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        ResponseWriter writer = context.getResponseWriter();
        AssertionUtil.assertNotNull((String)"ResponseWriter", (Object)writer);
        try {
            writer.endDocument();
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        HttpSession session = null;
        session = this.pageContext.getSession();
        if (session != null) {
            session.setAttribute("javax.faces.request.charset", (Object)this.pageContext.getResponse().getCharacterEncoding());
        }
        return rc;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        String localeStr = this.getLocale();
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = (Locale)ValueBindingUtil.getValue(context, localeStr);
        if (locale == null) {
            locale = LocaleUtil.getLocale((String)localeStr);
        }
        ((UIViewRoot)component).setLocale(locale);
        Config.set((ServletRequest)this.pageContext.getRequest(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)locale);
    }
}

