/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.unit;

import java.io.IOException;
import java.util.Locale;
import javax.faces.FactoryFinder;
import javax.faces.component.UIViewRoot;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.internal.ValidatorResource;
import org.seasar.framework.unit.S2FrameworkTestCase;
import org.seasar.teeda.core.application.navigation.NavigationResource;
import org.seasar.teeda.core.context.html.HtmlResponseWriter;
import org.seasar.teeda.core.managedbean.ManagedBeanFactory;
import org.seasar.teeda.core.managedbean.impl.ManagedBeanFactoryImpl;
import org.seasar.teeda.core.managedbean.impl.ManagedBeanScopeSaverImpl;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockApplicationFactory;
import org.seasar.teeda.core.mock.MockApplicationImpl;
import org.seasar.teeda.core.mock.MockExternalContext;
import org.seasar.teeda.core.mock.MockExternalContextImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockFacesContextFactory;
import org.seasar.teeda.core.mock.MockFacesContextImpl;
import org.seasar.teeda.core.mock.MockLifecycle;
import org.seasar.teeda.core.mock.MockLifecycleFactory;
import org.seasar.teeda.core.mock.MockLifecycleImpl;
import org.seasar.teeda.core.mock.MockNavigationHandler;
import org.seasar.teeda.core.mock.MockPhaseListener;
import org.seasar.teeda.core.mock.MockPropertyResolver;
import org.seasar.teeda.core.mock.MockRenderKit;
import org.seasar.teeda.core.mock.MockRenderKitFactory;
import org.seasar.teeda.core.mock.MockRenderKitImpl;
import org.seasar.teeda.core.mock.MockRenderer;
import org.seasar.teeda.core.mock.MockStateManager;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.mock.MockViewHandler;
import org.seasar.teeda.core.mock.MockViewHandlerImpl;
import org.seasar.teeda.core.scope.impl.S2ScopeTranslator;
import org.seasar.teeda.core.scope.impl.ScopeManagerImpl;

public abstract class TeedaTestCase
extends S2FrameworkTestCase {
    private MockExternalContext externalContext;
    private MockApplication application;
    private MockFacesContext facesContext;
    private MockLifecycle lifecycle;
    private MockRenderKit renderKit;
    private MockPhaseListener phaseListener;
    private MockNavigationHandler navigationHandler;
    private MockPropertyResolver propertyResolver;
    private MockVariableResolver variableResolver;
    private MockViewHandler viewHandler;
    private MockStateManager stateManager;

    public TeedaTestCase() {
    }

    public TeedaTestCase(String name) {
        super(name);
    }

    protected void setUpContainer() throws Throwable {
        super.setUpContainer();
        this.externalContext = new MockExternalContextImpl(this.getServletContext(), this.getRequest(), this.getResponse());
        this.application = new MockApplicationImpl();
        this.navigationHandler = new MockNavigationHandler();
        this.application.setNavigationHandler(this.navigationHandler);
        this.propertyResolver = new MockPropertyResolver();
        this.application.setPropertyResolver(this.propertyResolver);
        this.variableResolver = new MockVariableResolver();
        this.application.setVariableResolver(this.variableResolver);
        this.viewHandler = new MockViewHandlerImpl();
        this.application.setViewHandler(this.viewHandler);
        this.stateManager = new MockStateManager();
        this.application.setStateManager(this.stateManager);
        this.facesContext = new MockFacesContextImpl(this.externalContext, this.application);
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        responseWriter.setWriter(this.getResponse().getWriter());
        this.facesContext.setResponseWriter(responseWriter);
        UIViewRoot viewRoot = new UIViewRoot();
        viewRoot.setRenderKitId("HTML_BASIC");
        viewRoot.setLocale(Locale.getDefault());
        this.facesContext.setViewRoot(viewRoot);
        this.renderKit = new MockRenderKitImpl();
        MockRenderer renderer = new MockRenderer();
        this.renderKit.addRenderer("javax.faces.mock", "javax.faces.mock", renderer);
        this.lifecycle = new MockLifecycleImpl();
        this.phaseListener = new MockPhaseListener();
        this.lifecycle.addPhaseListener(this.phaseListener);
        this.initFactories();
        this.setFactories();
    }

    protected void initFactories() {
        FactoryFinder.setFactory("javax.faces.application.ApplicationFactory", "org.seasar.teeda.core.mock.MockApplicationFactory");
        FactoryFinder.setFactory("javax.faces.context.FacesContextFactory", "org.seasar.teeda.core.mock.MockFacesContextFactory");
        FactoryFinder.setFactory("javax.faces.lifecycle.LifecycleFactory", "org.seasar.teeda.core.mock.MockLifecycleFactory");
        FactoryFinder.setFactory("javax.faces.render.RenderKitFactory", "org.seasar.teeda.core.mock.MockRenderKitFactory");
    }

    protected void setFactories() {
        this.setApplicationFactory();
        this.setFacesContextFactory();
        this.setLifecycleFactory();
        this.setRenderKitFactory();
        this.setManagedBeanFactory();
    }

    protected void setApplicationFactory() {
        MockApplicationFactory appFactory = (MockApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        appFactory.setApplication(this.application);
    }

    protected void setFacesContextFactory() {
        MockFacesContextFactory facesContextFactory = (MockFacesContextFactory)FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
        facesContextFactory.setFacesContext(this.facesContext);
    }

    protected void setLifecycleFactory() {
        MockLifecycleFactory lifecycleFactory = (MockLifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        lifecycleFactory.addLifecycle("DEFAULT", this.lifecycle);
    }

    protected void setRenderKitFactory() {
        MockRenderKitFactory renderKitFactory = (MockRenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        renderKitFactory.addRenderKit("HTML_BASIC", this.renderKit);
    }

    protected void setManagedBeanFactory() {
        this.getContainer().register(ManagedBeanFactoryImpl.class);
        this.getContainer().register(ManagedBeanScopeSaverImpl.class);
        this.getContainer().register(ScopeManagerImpl.class);
        this.getContainer().register(S2ScopeTranslator.class);
    }

    protected ManagedBeanFactory getManagedBeanFactory() {
        return (ManagedBeanFactory)this.getContainer().getComponent((Object)ManagedBeanFactory.class);
    }

    protected String getResponseText() throws IOException {
        return this.getResponse().getWriter().toString();
    }

    protected void tearDownContainer() throws Throwable {
        this.externalContext = null;
        this.application = null;
        this.facesContext.release();
        this.facesContext = null;
        this.renderKit = null;
        this.phaseListener = null;
        this.navigationHandler = null;
        FactoryFinder.releaseFactories();
        NavigationResource.removeAll();
        ValidatorResource.removeAll();
        FacesConfigOptions.clear();
        super.tearDownContainer();
    }

    protected static void success() {
        TeedaTestCase.assertTrue((boolean)true);
    }

    protected static void notDoneYet() {
        TeedaTestCase.fail((String)"This test is not done yet.");
    }

    public MockApplication getApplication() {
        return this.application;
    }

    public void setApplication(MockApplication application) {
        this.application = application;
        this.setApplicationFactory();
        this.facesContext.setApplication(this.application);
    }

    public MockExternalContext getExternalContext() {
        return this.externalContext;
    }

    public void setExternalContext(MockExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    public MockFacesContext getFacesContext() {
        return this.facesContext;
    }

    public void setFacesContext(MockFacesContext facesContext) {
        this.facesContext = facesContext;
        this.setFacesContextFactory();
    }

    public MockLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(MockLifecycle lifecycle) {
        this.lifecycle = lifecycle;
        this.setLifecycleFactory();
    }

    public MockRenderKit getRenderKit() {
        return this.renderKit;
    }

    public void setRenderKit(MockRenderKit renderKit) {
        this.renderKit = renderKit;
        this.setRenderKitFactory();
    }

    public MockPropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public void setPropertyResolver(MockPropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
        this.application.setPropertyResolver(propertyResolver);
    }

    public MockVariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(MockVariableResolver variableResolver) {
        this.variableResolver = variableResolver;
        this.application.setVariableResolver(variableResolver);
    }

    public MockViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public void setViewHandler(MockViewHandler viewHandler) {
        this.viewHandler = viewHandler;
        this.application.setViewHandler(viewHandler);
    }
}

