/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.framework.util.DoubleConversionUtil;
import org.seasar.framework.util.FloatConversionUtil;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.LongConversionUtil;
import org.seasar.framework.util.ShortConversionUtil;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static boolean equalsIgnoreSequence(Object[] array1, Object[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        List<Object> list = Arrays.asList(array2);
        for (int i = 0; i < array1.length; ++i) {
            Object o1 = array1[i];
            if (list.contains(o1)) continue;
            return false;
        }
        return true;
    }

    public static String toString(Object[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i == 0) {
                sb.append('[');
            } else {
                sb.append(", ");
            }
            sb.append(String.valueOf(array[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    public static void setArrayValue(Object array, Class valueType, Object value, int index) {
        if (value == null) {
            return;
        }
        if (valueType == Integer.TYPE) {
            Array.setInt(array, index, IntegerConversionUtil.toPrimitiveInt((Object)value));
        } else if (valueType == Double.TYPE) {
            Array.setDouble(array, index, DoubleConversionUtil.toPrimitiveDouble((Object)value));
        } else if (valueType == Long.TYPE) {
            Array.setLong(array, index, LongConversionUtil.toPrimitiveLong((Object)value));
        } else if (valueType == Float.TYPE) {
            Array.setFloat(array, index, FloatConversionUtil.toPrimitiveFloat((Object)value));
        } else if (valueType == Short.TYPE) {
            Array.setShort(array, index, ShortConversionUtil.toPrimitiveShort((Object)value));
        } else if (valueType == Boolean.TYPE) {
            Array.setBoolean(array, index, BooleanConversionUtil.toPrimitiveBoolean((Object)value));
        } else if (valueType == Character.TYPE) {
            Array.setChar(array, index, ((Character)value).charValue());
        }
        Array.set(array, index, value);
    }

    public static Object[] toObjectArray(Object obj) {
        int length = Array.getLength(obj);
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Array.get(obj, i);
        }
        return array;
    }
}

