/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.exception.NoEditableValueHolderRuntimeException;

public class DecodeUtil {
    private DecodeUtil() {
    }

    public static void decode(FacesContext context, UIComponent component) {
        String clientId;
        AssertionUtil.assertNotNull((String)"context is null.", (Object)context);
        AssertionUtil.assertNotNull((String)"component is null.", (Object)component);
        if (!(component instanceof EditableValueHolder)) {
            throw new NoEditableValueHolderRuntimeException(component.getClass());
        }
        EditableValueHolder evh = (EditableValueHolder)((Object)component);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(context))) {
            Object submittedValue = paramMap.get(clientId);
            evh.setSubmittedValue(submittedValue);
        }
    }

    public static void decodeMany(FacesContext context, UIComponent component) {
        AssertionUtil.assertNotNull((String)"context is null.", (Object)context);
        AssertionUtil.assertNotNull((String)"component is null.", (Object)component);
        if (!(component instanceof EditableValueHolder)) {
            throw new NoEditableValueHolderRuntimeException(component.getClass());
        }
        EditableValueHolder evh = (EditableValueHolder)((Object)component);
        Map paramValuesMap = context.getExternalContext().getRequestParameterValuesMap();
        String clientId = component.getClientId(context);
        String[] value = null;
        if (paramValuesMap.containsKey(clientId)) {
            value = (String[])paramValuesMap.get(clientId);
        }
        if (value != null) {
            evh.setSubmittedValue(value);
        } else {
            evh.setSubmittedValue(new String[0]);
        }
    }
}

