/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import javax.faces.context.FacesContext;
import javax.faces.internal.FacesConfigOptions;
import org.seasar.framework.util.StringUtil;

public class JavaScriptPermissionUtil {
    public static final boolean JAVASCRIPT_DEFAULT_ALLOW = true;

    private JavaScriptPermissionUtil() {
    }

    public static boolean isJavaScriptPermitted(FacesContext context) {
        String requestServletPath = context.getExternalContext().getRequestPathInfo();
        String[] javascriptNotAllowedPath = FacesConfigOptions.getJavascriptNotPermittedPath();
        boolean javaScriptAllowed = true;
        if (javascriptNotAllowedPath == null) {
            return javaScriptAllowed;
        }
        for (int i = 0; i < javascriptNotAllowedPath.length; ++i) {
            String notAllowedPath = JavaScriptPermissionUtil.adjustNotAllowedPath(javascriptNotAllowedPath[i]);
            if ((requestServletPath == null || !StringUtil.startsWith((String)requestServletPath, (String)notAllowedPath)) && (requestServletPath != null || !notAllowedPath.equals("/"))) continue;
            javaScriptAllowed = false;
            break;
        }
        return javaScriptAllowed;
    }

    private static String adjustNotAllowedPath(String path) {
        if (path == null) {
            return null;
        }
        String notAllowedPath = path.trim();
        if (!notAllowedPath.startsWith("/")) {
            notAllowedPath = "/" + notAllowedPath;
        }
        if (!notAllowedPath.endsWith("/")) {
            notAllowedPath = notAllowedPath + "/";
        }
        return notAllowedPath;
    }
}

