/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.util;

import java.util.Comparator;

import jp.sf.pal.blog.model.BlogTrackback;

public class BlogTrackbackComparator implements Comparator
{
    public static final int ASC = 1;

    public static final int DESC = -1;

    private int order = 0;

    public BlogTrackbackComparator(int order)
    {
        this.order = order;
    }

    public int compare(Object o1, Object o2)
    {
        if (o1 instanceof BlogTrackback && o2 instanceof BlogTrackback)
        {
            BlogTrackback bt1 = (BlogTrackback) o1;
            BlogTrackback bt2 = (BlogTrackback) o2;
            return bt1.getCreatedtime().compareTo(bt2.getCreatedtime()) * order;
        }
        return 0;
    }

}
