/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.TypeNames;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.SQLStateConverter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.TableHiLoGenerator;
import org.hibernate.sql.ANSICaseFragment;
import org.hibernate.sql.ANSIJoinFragment;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public abstract class Dialect {
    private static final Log log = LogFactory.getLog((Class)Dialect.class);
    static final String DEFAULT_BATCH_SIZE = "15";
    static final String NO_BATCH = "0";
    private static final Map STANDARD_AGGREGATE_FUNCTIONS = new HashMap();
    private final TypeNames typeNames = new TypeNames();
    private final TypeNames hibernateTypeNames = new TypeNames();
    private final Properties properties = new Properties();
    private final Map sqlFunctions = new HashMap();
    private final Set sqlKeywords = new HashSet();
    public static final String QUOTE = "`\"[";
    public static final String CLOSED_QUOTE = "`\"]";
    private static final ViolatedConstraintNameExtracter EXTRACTER;

    protected Dialect() {
        log.info((Object)("Using dialect: " + this));
        this.sqlFunctions.putAll(STANDARD_AGGREGATE_FUNCTIONS);
        this.registerFunction("substring", new SQLFunctionTemplate(Hibernate.STRING, "substring(?1, ?2, ?3)"));
        this.registerFunction("locate", new SQLFunctionTemplate(Hibernate.INTEGER, "locate(?1, ?2, ?3)"));
        this.registerFunction("trim", new SQLFunctionTemplate(Hibernate.STRING, "trim(?1 ?2 ?3 ?4)"));
        this.registerFunction("length", new StandardSQLFunction("length", Hibernate.INTEGER));
        this.registerFunction("bit_length", new StandardSQLFunction("bit_length", Hibernate.INTEGER));
        this.registerFunction("coalesce", new StandardSQLFunction("coalesce"));
        this.registerFunction("nullif", new StandardSQLFunction("nullif"));
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("mod", new StandardSQLFunction("mod", Hibernate.INTEGER));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", Hibernate.DOUBLE));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("cast", new CastFunction());
        this.registerFunction("extract", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(?1 ?2 ?3)"));
        this.registerFunction("second", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(second from ?1)"));
        this.registerFunction("minute", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(minute from ?1)"));
        this.registerFunction("hour", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(hour from ?1)"));
        this.registerFunction("day", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(day from ?1)"));
        this.registerFunction("month", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(month from ?1)"));
        this.registerFunction("year", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(year from ?1)"));
        this.registerFunction("str", new SQLFunctionTemplate(Hibernate.STRING, "cast(?1 as char)"));
        this.registerHibernateType(-5, Hibernate.BIG_INTEGER.getName());
        this.registerHibernateType(-2, Hibernate.BINARY.getName());
        this.registerHibernateType(-7, Hibernate.BOOLEAN.getName());
        this.registerHibernateType(1, Hibernate.CHARACTER.getName());
        this.registerHibernateType(91, Hibernate.DATE.getName());
        this.registerHibernateType(8, Hibernate.DOUBLE.getName());
        this.registerHibernateType(6, Hibernate.FLOAT.getName());
        this.registerHibernateType(4, Hibernate.INTEGER.getName());
        this.registerHibernateType(5, Hibernate.SHORT.getName());
        this.registerHibernateType(-6, Hibernate.BYTE.getName());
        this.registerHibernateType(92, Hibernate.TIME.getName());
        this.registerHibernateType(93, Hibernate.TIMESTAMP.getName());
        this.registerHibernateType(12, Hibernate.STRING.getName());
        this.registerHibernateType(-3, Hibernate.BINARY.getName());
        this.registerHibernateType(2, Hibernate.BIG_DECIMAL.getName());
        this.registerHibernateType(2004, Hibernate.BLOB.getName());
        this.registerHibernateType(2005, Hibernate.CLOB.getName());
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getTypeName(int code) throws HibernateException {
        String result = this.typeNames.get(code);
        if (result == null) {
            throw new HibernateException("No default type mapping for (java.sql.Types) " + code);
        }
        return result;
    }

    public String getHibernateTypeName(int code) throws HibernateException {
        String result = this.hibernateTypeNames.get(code);
        if (result == null) {
            throw new HibernateException("No Hibernate type mapping for java.sql.Types code: " + code);
        }
        return result;
    }

    public String getHibernateTypeName(int code, int length, int precision, int scale) throws HibernateException {
        String result = this.hibernateTypeNames.get(code, length, precision, scale);
        if (result == null) {
            throw new HibernateException("No Hibernate type mapping for java.sql.Types code: " + code + ", length: " + length);
        }
        return result;
    }

    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        String result = this.typeNames.get(code, length, precision, scale);
        if (result == null) {
            throw new HibernateException("No type mapping for java.sql.Types code: " + code + ", length: " + length);
        }
        return result;
    }

    public String getCastTypeName(int code) {
        return this.getTypeName(code, 255, 19, 2);
    }

    protected void registerFunction(String name, SQLFunction function) {
        this.sqlFunctions.put(name, function);
    }

    protected void registerKeyword(String word) {
        this.sqlKeywords.add(word);
    }

    public Set getKeywords() {
        return this.sqlKeywords;
    }

    protected void registerColumnType(int code, int capacity, String name) {
        this.typeNames.put(code, capacity, name);
    }

    protected void registerColumnType(int code, String name) {
        this.typeNames.put(code, name);
    }

    protected void registerHibernateType(int sqlcode, String name) {
        this.hibernateTypeNames.put(sqlcode, name);
    }

    protected void registerHibernateType(int sqlcode, int capacity, String name) {
        this.hibernateTypeNames.put(sqlcode, capacity, name);
    }

    public boolean hasAlterTable() {
        return true;
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public boolean forUpdateOfColumns() {
        return false;
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString();
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString(aliases);
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString();
    }

    public boolean supportsUnique() {
        return true;
    }

    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return true;
    }

    public String getAddColumnString() {
        throw new UnsupportedOperationException("No add column syntax supported by Dialect");
    }

    public String getDropForeignKeyString() {
        return " drop constraint ";
    }

    public String getTableTypeString() {
        return "";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuffer res = new StringBuffer(30);
        res.append(" add constraint ").append(constraintName).append(" foreign key (").append(StringHelper.join(", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            res.append(" (").append(StringHelper.join(", ", primaryKey)).append(')');
        }
        return res.toString();
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint " + constraintName + " primary key ";
    }

    public String getNullColumnString() {
        return "";
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsInsertSelectIdentity() {
        return false;
    }

    public String appendIdentitySelectToInsert(String insertString) {
        return insertString;
    }

    protected String getIdentitySelectString() throws MappingException {
        throw new MappingException("Dialect does not support identity key generation");
    }

    public String getIdentitySelectString(String table, String column, int type) throws MappingException {
        return this.getIdentitySelectString();
    }

    protected String getIdentityColumnString() throws MappingException {
        throw new MappingException("Dialect does not support identity key generation");
    }

    public String getIdentityColumnString(int type) throws MappingException {
        return this.getIdentityColumnString();
    }

    public String getIdentityInsertString() {
        return null;
    }

    public String getNoColumnsInsertString() {
        return "values ( )";
    }

    public String getSequenceNextValString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String getSelectSequenceNextValString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    protected String getCreateSequenceString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String[] getCreateSequenceStrings(String sequenceName) throws MappingException {
        return new String[]{this.getCreateSequenceString(sequenceName)};
    }

    protected String getDropSequenceString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String[] getDropSequenceStrings(String sequenceName) throws MappingException {
        return new String[]{this.getDropSequenceString(sequenceName)};
    }

    public String getQuerySequencesString() {
        return null;
    }

    public static Dialect getDialect() throws HibernateException {
        String dialectName = Environment.getProperties().getProperty("hibernate.dialect");
        if (dialectName == null) {
            throw new HibernateException("The dialect was not set. Set the property hibernate.dialect.");
        }
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", e);
        }
    }

    public static Dialect getDialect(Properties props) throws HibernateException {
        String dialectName = props.getProperty("hibernate.dialect");
        if (dialectName == null) {
            return Dialect.getDialect();
        }
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", e);
        }
    }

    public final Properties getDefaultProperties() {
        return this.properties;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public JoinFragment createOuterJoinFragment() {
        return new ANSIJoinFragment();
    }

    public CaseFragment createCaseFragment() {
        return new ANSICaseFragment();
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    public String getLimitString(String querySelect, boolean hasOffset) {
        throw new UnsupportedOperationException("paged queries not supported");
    }

    public String getLimitString(String querySelect, int offset, int limit) {
        return this.getLimitString(querySelect, offset > 0);
    }

    public boolean supportsVariableLimit() {
        return this.supportsLimit();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return false;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public final Map getFunctions() {
        return this.sqlFunctions;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean hasDataTypeInIdentityColumn() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public String appendLockHint(LockMode mode, String tableName) {
        return tableName;
    }

    public Class getNativeIdentifierGeneratorClass() {
        if (this.supportsIdentityColumns()) {
            return IdentityGenerator.class;
        }
        if (this.supportsSequences()) {
            return SequenceGenerator.class;
        }
        return TableHiLoGenerator.class;
    }

    public String getSelectGUIDString() {
        throw new UnsupportedOperationException("dialect does not support GUIDs");
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getSelectClauseNullString(int sqlType) {
        return "null";
    }

    public boolean supportsNotNullUnique() {
        return true;
    }

    public SQLExceptionConverter buildSQLExceptionConverter() {
        return new SQLStateConverter(this.getViolatedConstraintNameExtracter());
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public final String quote(String column) {
        if (column.charAt(0) == '`') {
            return this.openQuote() + column.substring(1, column.length() - 1) + this.closeQuote();
        }
        return column;
    }

    public boolean hasSelfReferentialForeignKeyBug() {
        return false;
    }

    public boolean useInputStreamToInsertBlob() {
        return true;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public boolean supportsUnionAll() {
        return false;
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public String getTableComment(String comment) {
        return "";
    }

    public String getColumnComment(String comment) {
        return "";
    }

    public String transformSelectString(String select) {
        return select;
    }

    public boolean supportsTemporaryTables() {
        return false;
    }

    public String generateTemporaryTableName(String baseTableName) {
        return "HT_" + baseTableName;
    }

    public String getCreateTemporaryTableString() {
        return "create table";
    }

    public boolean performTemporaryTableDDLInIsolation() {
        return false;
    }

    public String getCreateTemporaryTablePostfix() {
        return "";
    }

    public boolean dropTemporaryTableAfterUse() {
        return true;
    }

    public String getForUpdateString(LockMode lockMode) {
        if (lockMode == LockMode.UPGRADE) {
            return this.getForUpdateString();
        }
        if (lockMode == LockMode.UPGRADE_NOWAIT) {
            return this.getForUpdateNowaitString();
        }
        return "";
    }

    public int getMaxAliasLength() {
        return 10;
    }

    public boolean supportsCurrentTimestampSelection() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "1" : NO_BATCH;
    }

    public boolean supportsParametersInInsertSelect() {
        return true;
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "current_timestamp";
    }

    static {
        STANDARD_AGGREGATE_FUNCTIONS.put("count", new StandardSQLFunction("count"){

            public Type getReturnType(Type columnType, Mapping mapping) {
                return Hibernate.INTEGER;
            }
        });
        STANDARD_AGGREGATE_FUNCTIONS.put("avg", new StandardSQLFunction("avg"){

            public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
                int[] sqlTypes;
                try {
                    sqlTypes = columnType.sqlTypes(mapping);
                }
                catch (MappingException me) {
                    throw new QueryException(me);
                }
                if (sqlTypes.length != 1) {
                    throw new QueryException("multi-column type in avg()");
                }
                int sqlType = sqlTypes[0];
                if (sqlType == 4 || sqlType == -5 || sqlType == -6) {
                    return Hibernate.FLOAT;
                }
                return columnType;
            }
        });
        STANDARD_AGGREGATE_FUNCTIONS.put("max", new StandardSQLFunction("max"));
        STANDARD_AGGREGATE_FUNCTIONS.put("min", new StandardSQLFunction("min"));
        STANDARD_AGGREGATE_FUNCTIONS.put("sum", new StandardSQLFunction("sum"));
        EXTRACTER = new ViolatedConstraintNameExtracter(){

            public String extractConstraintName(SQLException sqle) {
                return null;
            }
        };
    }
}

