/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.portletfilter;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

public class PortletFilterChain {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$portals$bridges$portletfilter$PortletFilterChain == null ? (class$org$apache$portals$bridges$portletfilter$PortletFilterChain = PortletFilterChain.class$("org.apache.portals.bridges.portletfilter.PortletFilterChain")) : class$org$apache$portals$bridges$portletfilter$PortletFilterChain));
    public static final int INCREMENT = 10;
    public static final String PORTLET_FILTERS = "portlet-filters";
    private PortletFilterConfig[] filters = new PortletFilterConfig[0];
    private int renderPosition = 0;
    private int processActionPosition = 0;
    private int n = 0;
    private Portlet portlet = null;
    static /* synthetic */ Class class$org$apache$portals$bridges$portletfilter$PortletFilterChain;

    public PortletFilterChain(PortletConfig config) {
        String portletFilters = config.getInitParameter(PORTLET_FILTERS);
        StringTokenizer st = new StringTokenizer(portletFilters, ", ");
        while (st.hasMoreTokens()) {
            String className = st.nextToken();
            try {
                this.addPortletFilter(new PortletFilterConfig(className, config));
            }
            catch (PortletException e) {
                log.warn((Object)("Invalid portlet filter: " + className), (Throwable)e);
            }
        }
    }

    public void renderFilter(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.renderPosition < this.n) {
            PortletFilterConfig filterConfig = this.filters[this.renderPosition++];
            PortletFilter filter = filterConfig.getPortletFilter();
            filter.renderFilter(request, response, this);
            return;
        }
        this.renderPosition = 0;
        this.portlet.render(request, response);
    }

    public void processActionFilter(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (this.processActionPosition < this.n) {
            PortletFilterConfig filterConfig = this.filters[this.processActionPosition++];
            PortletFilter filter = filterConfig.getPortletFilter();
            filter.processActionFilter(request, response, this);
            return;
        }
        this.processActionPosition = 0;
        this.portlet.processAction(request, response);
    }

    public void addPortletFilter(PortletFilterConfig filterConfig) {
        if (filterConfig != null && filterConfig.getPortletFilter() != null) {
            if (this.n == this.filters.length) {
                PortletFilterConfig[] newFilters = new PortletFilterConfig[this.n + 10];
                System.arraycopy(this.filters, 0, newFilters, 0, this.n);
                this.filters = newFilters;
            }
            this.filters[this.n++] = filterConfig;
        }
    }

    public void release() {
        this.n = 0;
        this.renderPosition = 0;
        this.processActionPosition = 0;
        for (int i = 0; i < this.n; ++i) {
            this.filters[i].release();
        }
        this.portlet = null;
    }

    public void setPortlet(Portlet portlet) {
        this.portlet = portlet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

