/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.cooldeploy;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.cooldeploy.CoolProject;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.URLUtil;

public class CoolComponentAutoRegister
implements ClassTraversal.ClassHandler {
    public static final String INIT_METHOD = "registerAll";
    public static final String container_BINDING = "bindingType=must";
    private S2Container container;
    private Map strategies = new HashMap();
    private List projects = new ArrayList();

    public CoolComponentAutoRegister() {
        this.addStrategy("file", new FileSystemStrategy());
        this.addStrategy("jar", new JarFileStrategy());
        this.addStrategy("zip", new ZipFileStrategy());
    }

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public Map getStrategies() {
        return this.strategies;
    }

    protected Strategy getStrategy(String protocol) {
        return (Strategy)this.strategies.get(protocol);
    }

    protected void addStrategy(String protocol, Strategy strategy) {
        this.strategies.put(protocol, strategy);
    }

    public CoolProject getProject(int index) {
        return (CoolProject)this.projects.get(index);
    }

    public CoolProject[] getProjects() {
        return this.projects.toArray(new CoolProject[this.projects.size()]);
    }

    public int getProjectSize() {
        return this.projects.size();
    }

    public void addProject(CoolProject project) {
        this.projects.add(project);
    }

    public void registerAll() {
        String path = this.container.getPath();
        URL url = ResourceUtil.getResource(path);
        Strategy strategy = this.getStrategy(url.getProtocol());
        strategy.registerAll(path, url);
    }

    public void processClass(String packageName, String shortClassName) {
        CoolProject project;
        int m;
        String className = ClassUtil.concatName(packageName, shortClassName);
        for (int i = 0; !(i >= this.getProjectSize() || (m = (project = this.getProject(i)).matchClassName(className)) == 2 || m != 1 && project.loadComponentDef(ClassUtil.forName(className))); ++i) {
        }
    }

    protected class ZipFileStrategy
    implements Strategy {
        protected ZipFileStrategy() {
        }

        public void registerAll(String path, URL url) {
            JarFile jarFile = this.createJarFile(url);
            ClassTraversal.forEach(jarFile, (ClassTraversal.ClassHandler)CoolComponentAutoRegister.this);
        }

        protected JarFile createJarFile(URL url) {
            String urlString = ResourceUtil.toExternalForm(url);
            int pos = urlString.lastIndexOf(33);
            String jarFileName = urlString.substring("zip:".length(), pos);
            return JarFileUtil.create(new File(jarFileName));
        }
    }

    protected class JarFileStrategy
    implements Strategy {
        protected JarFileStrategy() {
        }

        public void registerAll(String path, URL url) {
            JarFile jarFile = this.createJarFile(url);
            ClassTraversal.forEach(jarFile, (ClassTraversal.ClassHandler)CoolComponentAutoRegister.this);
        }

        protected JarFile createJarFile(URL url) {
            URL nestedUrl = URLUtil.create(url.getPath());
            String path = nestedUrl.getPath();
            int pos = path.lastIndexOf(33);
            String jarFileName = path.substring(0, pos);
            return JarFileUtil.create(new File(jarFileName));
        }
    }

    protected class FileSystemStrategy
    implements Strategy {
        protected FileSystemStrategy() {
        }

        public void registerAll(String path, URL url) {
            File rootDir = this.getRootDir(path);
            ClassTraversal.forEach(rootDir, (ClassTraversal.ClassHandler)CoolComponentAutoRegister.this);
        }

        protected File getRootDir(String path) {
            File file = ResourceUtil.getResourceAsFile(path);
            String[] names = StringUtil.split(path, "/");
            for (int i = 0; i < names.length; ++i) {
                file = file.getParentFile();
            }
            return file;
        }
    }

    protected static interface Strategy {
        public void registerAll(String var1, URL var2);
    }
}

