/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy.creator;

import org.seasar.framework.container.hotdeploy.creator.AbstractOndemandCreator;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

public class SinglePackageOndemandCreator
extends AbstractOndemandCreator {
    private String middlePackageName;

    public SinglePackageOndemandCreator(NamingConvention namingConvention) {
        super(namingConvention);
    }

    public String getMiddlePackageName() {
        return this.middlePackageName;
    }

    public void setMiddlePackageName(String middlePackageName) {
        this.middlePackageName = middlePackageName;
    }

    protected String composeClassName(String rootPackageName, String componentName) {
        StringBuffer sb = new StringBuffer(100);
        this.concatName(sb, rootPackageName);
        this.concatName(sb, this.middlePackageName);
        String[] names = StringUtil.split(componentName, "_");
        for (int i = 0; i < names.length - 1; ++i) {
            this.concatName(sb, names[i]);
        }
        String shortClassName = StringUtil.capitalize(names[names.length - 1]);
        this.concatName(sb, shortClassName);
        return sb.toString();
    }

    protected boolean isTargetMiddlePackage(String rootPackageName, String className) {
        String s = ClassUtil.concatName(rootPackageName, this.middlePackageName);
        if (s != null) {
            return className.startsWith(s);
        }
        return true;
    }

    protected Class getTargetClass(String subsystemPackageName, String componentName) {
        String className = this.composeClassName(subsystemPackageName, componentName);
        return ClassUtil.forName(className);
    }

    protected String getTargetClassName(String rootPackageName, String componentName) {
        return this.composeClassName(rootPackageName, componentName);
    }
}

