/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public final class StringUtil {
    public static final String[] EMPTY_STRINGS = new String[0];

    private StringUtil() {
    }

    public static final boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static final String replace(String text, String fromText, String toText) {
        if (text == null || fromText == null || toText == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(100);
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(fromText, pos2)) == 0) {
                buf.append(toText);
                pos2 = fromText.length();
                continue;
            }
            if (pos <= 0) break;
            buf.append(text.substring(pos2, pos));
            buf.append(toText);
            pos2 = pos + fromText.length();
        }
        buf.append(text.substring(pos2));
        return buf.toString();
    }

    public static String[] split(String str, String delim) {
        if (str == null) {
            return EMPTY_STRINGS;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreElements()) {
            list.add(st.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String ltrim(String text) {
        return StringUtil.ltrim(text, null);
    }

    public static final String ltrim(String text, String trimText) {
        int pos;
        if (text == null) {
            return null;
        }
        if (trimText == null) {
            trimText = " ";
        }
        for (pos = 0; pos < text.length() && trimText.indexOf(text.charAt(pos)) >= 0; ++pos) {
        }
        return text.substring(pos);
    }

    public static final String rtrim(String text) {
        return StringUtil.rtrim(text, null);
    }

    public static final String rtrim(String text, String trimText) {
        int pos;
        if (text == null) {
            return null;
        }
        if (trimText == null) {
            trimText = " ";
        }
        for (pos = text.length() - 1; pos >= 0 && trimText.indexOf(text.charAt(pos)) >= 0; --pos) {
        }
        return text.substring(0, pos + 1);
    }

    public static String decapitalize(String name) {
        if (StringUtil.isEmpty(name)) {
            return name;
        }
        char[] chars = name.toCharArray();
        if (chars.length >= 2 && Character.isUpperCase(chars[0]) && Character.isUpperCase(chars[1])) {
            return name;
        }
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String capitalize(String name) {
        if (StringUtil.isEmpty(name)) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static boolean startsWith(String text, String fragment) {
        if (text == null || fragment == null) {
            return false;
        }
        return text.length() > fragment.length() && text.substring(0, fragment.length()).equalsIgnoreCase(fragment);
    }

    public static boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static boolean contains(String str, char ch) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        return str.indexOf(ch) >= 0;
    }

    public static boolean contains(String s1, String s2) {
        if (StringUtil.isEmpty(s1)) {
            return false;
        }
        return s1.indexOf(s2) >= 0;
    }

    public static boolean equals(String target1, String target2) {
        return target1 == null ? target2 == null : target1.equals(target2);
    }

    public static boolean equalsIgnoreCase(String target1, String target2) {
        return target1 == null ? target2 == null : target1.equalsIgnoreCase(target2);
    }

    public static boolean endsWithIgnoreCase(String target1, String target2) {
        int length2;
        if (target1 == null || target2 == null) {
            return false;
        }
        int length1 = target1.length();
        if (length1 < (length2 = target2.length())) {
            return false;
        }
        String s1 = target1.substring(length1 - length2);
        return s1.equalsIgnoreCase(target2);
    }

    public static boolean startsWithIgnoreCase(String target1, String target2) {
        int length2;
        if (target1 == null || target2 == null) {
            return false;
        }
        int length1 = target1.length();
        if (length1 < (length2 = target2.length())) {
            return false;
        }
        String s1 = target1.substring(0, target2.length());
        return s1.equalsIgnoreCase(target2);
    }
}

