/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.util.el;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class ActionsMap
implements Map {
    private Set keys;

    public ActionsMap() {
    }

    public ActionsMap(Set keys) {
        this.keys = keys;
    }

    public abstract void performAction(String var1);

    public int size() {
        return this.keys.size();
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    public boolean containsValue(Object value) {
        if (!(value instanceof Boolean)) {
            return false;
        }
        return (Boolean)value;
    }

    public Object get(Object key) {
        return Boolean.FALSE;
    }

    public Boolean put(String key, Boolean value) {
        if (value != null && value.booleanValue()) {
            this.performAction(key);
        }
        return Boolean.FALSE;
    }

    public Object remove(Object key) {
        if (this.keys.remove(key)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public void putAll(Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object obj = entry.getValue();
            if (!(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
            this.performAction((String)entry.getKey());
        }
    }

    public void clear() {
        this.keys.clear();
    }

    public Set keySet() {
        return this.keys;
    }

    public Collection values() {
        return Collections.nCopies(this.keys.size(), Boolean.FALSE);
    }

    public Set entrySet() {
        HashSet<CommandEntry> set = new HashSet<CommandEntry>(this.keys.size());
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            String command = (String)it.next();
            set.add(new CommandEntry(command));
        }
        return set;
    }

    private class CommandEntry
    implements Map.Entry {
        private final String command;
        private boolean commandPerformed = false;

        public CommandEntry(String command) {
            this.command = command;
        }

        public Object getKey() {
            return this.command;
        }

        public Object getValue() {
            return this.commandPerformed;
        }

        public Object setValue(Object performCommand) {
            if (performCommand instanceof Boolean && ((Boolean)performCommand).booleanValue()) {
                ActionsMap.this.performAction(this.command);
                this.commandPerformed = true;
            }
            return this.commandPerformed;
        }
    }
}

