/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.MethodUtil;

public class ComponentAttributesMap
implements Map,
Serializable {
    private static final long serialVersionUID = 1L;
    private UIComponent component = null;
    private Map attributes = null;
    private BeanDesc beanDesc = null;
    private static Object[] EMPTY_ARGS = new Object[0];

    public ComponentAttributesMap(UIComponent component) {
        this(component, new HashMap());
    }

    public ComponentAttributesMap(UIComponent component, Map attributes) {
        this.component = component;
        this.attributes = attributes;
        this.setupPropertyDesc();
    }

    public int size() {
        return this.attributes.size();
    }

    public void clear() {
        this.attributes.clear();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public boolean containsKey(Object key) {
        if (this.beanDesc.hasPropertyDesc((String)key)) {
            return false;
        }
        return this.attributes.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.attributes.containsValue(value);
    }

    public Collection values() {
        return this.attributes.values();
    }

    public void putAll(Map map) {
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set entrySet() {
        return this.attributes.entrySet();
    }

    public Set keySet() {
        return this.attributes.keySet();
    }

    public Object get(Object key) {
        String k = (String)key;
        if (this.beanDesc.hasPropertyDesc(k)) {
            PropertyDesc propertyDesc = this.beanDesc.getPropertyDesc(k);
            Object value = this.getComponentProperty(propertyDesc);
            if (value != null) {
                return value;
            }
            ValueBinding vb = this.component.getValueBinding((String)key);
            return vb != null ? vb.getValue(FacesContext.getCurrentInstance()) : null;
        }
        return this.attributes.get((String)key);
    }

    public Object remove(Object key) {
        String k = (String)key;
        if (this.beanDesc.hasPropertyDesc(k)) {
            throw new IllegalArgumentException("can't remove component property");
        }
        return this.attributes.remove(key);
    }

    public Object put(Object key, Object value) {
        AssertionUtil.assertNotNull((String)"key", (Object)key);
        AssertionUtil.assertNotNull((String)"value", (Object)value);
        ComponentAttributesMap.assertKeyIsString(key);
        String k = (String)key;
        PropertyDesc propertyDesc = null;
        if (this.beanDesc.hasPropertyDesc(k)) {
            propertyDesc = this.beanDesc.getPropertyDesc(k);
        }
        Object returnValue = null;
        if (propertyDesc != null && propertyDesc.hasReadMethod()) {
            returnValue = this.getComponentProperty(propertyDesc);
            this.setComponentProperty(propertyDesc, value);
        } else {
            returnValue = this.attributes.put(key, value);
        }
        return returnValue;
    }

    private void setupPropertyDesc() {
        Class<?> clazz = this.component.getClass();
        this.beanDesc = BeanDescFactory.getBeanDesc(clazz);
    }

    private void setComponentProperty(PropertyDesc propertyDesc, Object value) {
        if (!propertyDesc.hasWriteMethod()) {
            throw new IllegalArgumentException("component property [" + propertyDesc.getPropertyName() + "] is not writeable");
        }
        Method m = propertyDesc.getWriteMethod();
        MethodUtil.invoke((Method)m, (Object)this.component, (Object[])new Object[]{value});
    }

    private Object getComponentProperty(PropertyDesc propertyDesc) {
        Method m = propertyDesc.getReadMethod();
        return MethodUtil.invoke((Method)m, (Object)this.component, (Object[])EMPTY_ARGS);
    }

    public Map getAttributesActual() {
        return this.attributes;
    }

    private static void assertKeyIsString(Object key) {
        if (!(key instanceof String)) {
            throw new ClassCastException("key must be a String");
        }
    }
}

