/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.ComponentUtil_;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.ClassLoaderUtil;

public class FacesMessageUtil {
    private static final String DETAIL_SUFFIX = "_detail";

    private FacesMessageUtil() {
    }

    public static void addErrorMessage(FacesContext context, UIComponent component, String messageId) {
        String clientId = component.getClientId(context);
        Locale locale = ComponentUtil_.getLocale(context);
        FacesMessage message = FacesMessageUtil.getMessage(context, locale, FacesMessage.SEVERITY_ERROR, messageId, null);
        context.addMessage(clientId, message);
    }

    public static void addErrorMessage(FacesContext context, UIComponent component, String messageId, Object[] args) {
        String clientId = component.getClientId(context);
        Locale locale = ComponentUtil_.getLocale(context);
        FacesMessage message = FacesMessageUtil.getMessage(context, locale, FacesMessage.SEVERITY_ERROR, messageId, args);
        context.addMessage(clientId, message);
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object[] args) {
        Locale locale = ComponentUtil_.getLocale(context);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return FacesMessageUtil.getMessage(context, locale, FacesMessage.SEVERITY_ERROR, messageId, args);
    }

    protected static FacesMessage getMessage(FacesContext context, Locale locale, FacesMessage.Severity severity, String messageId, Object[] args) {
        ResourceBundle bundle = FacesMessageUtil.getResourceBundle(context, locale);
        String summary = FacesMessageUtil.getBundleString(bundle, messageId);
        String detail = FacesMessageUtil.getBundleString(bundle, messageId + DETAIL_SUFFIX);
        if (summary == null) {
            ResourceBundle defaultBundle = FacesMessageUtil.getDefaultBundle(context, locale);
            summary = FacesMessageUtil.getBundleString(defaultBundle, messageId);
            if (summary != null) {
                detail = FacesMessageUtil.getBundleString(defaultBundle, messageId + DETAIL_SUFFIX);
            } else {
                detail = FacesMessageUtil.getBundleString(bundle, messageId + DETAIL_SUFFIX);
                if (detail == null) {
                    detail = FacesMessageUtil.getBundleString(defaultBundle, messageId + DETAIL_SUFFIX);
                }
            }
        }
        if (summary != null) {
            summary = FacesMessageUtil.getFormattedMessage(summary, locale, args);
        }
        if (detail != null) {
            detail = FacesMessageUtil.getFormattedMessage(detail, locale, args);
        }
        return new FacesMessage(severity, summary, detail);
    }

    private static ResourceBundle getResourceBundle(FacesContext context, Locale locale) {
        ResourceBundle bundle = null;
        String appBundleName = context.getApplication().getMessageBundle();
        if (appBundleName != null) {
            bundle = FacesMessageUtil.getBundle(context, locale, appBundleName);
        }
        if (bundle == null) {
            bundle = FacesMessageUtil.getDefaultBundle(context, locale);
        }
        return bundle;
    }

    private static ResourceBundle getDefaultBundle(FacesContext context, Locale locale) {
        return FacesMessageUtil.getBundle(context, locale, "javax.faces.Messages");
    }

    private static ResourceBundle getBundle(FacesContext context, Locale locale, String bundleName) {
        ResourceBundle bundle = null;
        ClassLoader loader = ClassLoaderUtil.getClassLoader(context);
        try {
            bundle = ResourceBundle.getBundle(bundleName, locale, loader);
        }
        catch (MissingResourceException e) {
            context.getExternalContext().log("ResourceBundle " + bundleName + " could not be found.");
        }
        return bundle;
    }

    private static String getBundleString(ResourceBundle bundle, String key) {
        if (bundle == null) {
            return null;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ignore) {
            return null;
        }
    }

    private static String getFormattedMessage(String message, Locale locale, Object[] args) {
        if (args == null || args.length == 0) {
            return message;
        }
        return new MessageFormat(message, locale).format(args);
    }
}

