/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.seasar.framework.container.factory.ResourceResolver;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.URLUtil;
import org.seasar.framework.xml.SaxHandlerParser;
import org.seasar.teeda.core.config.faces.AbstractFacesConfigurator;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.impl.FacesConfigUtil;
import org.seasar.teeda.core.util.ClassLoaderUtil;

public class MetaInfFacesConfigurator
extends AbstractFacesConfigurator {
    private static final Logger logger_ = Logger.getLogger((Class)MetaInfFacesConfigurator.class);
    private String path_ = "/WEB-INF/lib/";

    public MetaInfFacesConfigurator() {
        this.setResourceResolver(new MetaInfResourceResolver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacesConfig configure() {
        InputStream is;
        String path = this.getPath();
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("target file path = " + path));
        }
        SaxHandlerParser parser = this.createSaxHandlerParser();
        ArrayList<FacesConfig> list = new ArrayList<FacesConfig>();
        while ((is = this.resourceResolver_.getInputStream(path)) != null) {
            try {
                FacesConfig config = (FacesConfig)parser.parse(is);
                list.add(config);
            }
            finally {
                InputStreamUtil.close((InputStream)is);
            }
        }
        return FacesConfigUtil.collectAllFacesConfig(list);
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    protected static class MetaInfResourceResolver
    implements ResourceResolver {
        private Iterator resources_;
        private boolean inited_ = false;

        public InputStream getInputStream(String path) {
            if (!this.inited_) {
                this.initialize(path);
                this.inited_ = true;
            }
            if (this.hasNext()) {
                URL url = (URL)this.resources_.next();
                return URLUtil.openStream((URL)url);
            }
            return null;
        }

        private boolean hasNext() {
            return this.resources_ != null && this.resources_.hasNext();
        }

        private void initialize(String path) {
            ClassLoader loader = ClassLoaderUtil.getClassLoader(this);
            LinkedList<URL> list = new LinkedList<URL>();
            Iterator itr = ClassLoaderUtil.getResources(loader, "META-INF/faces-config.xml");
            while (itr.hasNext()) {
                URL url = (URL)itr.next();
                if (url.toExternalForm().indexOf(path) == -1) continue;
                list.add(0, url);
            }
            this.resources_ = list.iterator();
        }
    }
}

