/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import org.seasar.framework.util.StringUtil;

public class HtmlRenderKitUtil {
    public static String[] removeSemiColon(String[] contentTypes) {
        for (int i = 0; i < contentTypes.length; ++i) {
            String type = contentTypes[i];
            int index = type.indexOf(";");
            if (index == -1) continue;
            contentTypes[i] = type = type.substring(0, index);
        }
        return contentTypes;
    }

    public static String getContentType(String contentTypeList) {
        String[] strs = StringUtil.split((String)contentTypeList, (String)",");
        String[] contentTypes = HtmlRenderKitUtil.removeSemiColon(strs);
        for (int i = 0; i < contentTypes.length; ++i) {
            String type = contentTypes[i].trim();
            if (HtmlRenderKitUtil.isHtmlContentType(type)) {
                return "text/html";
            }
            if (!HtmlRenderKitUtil.isXmlContentType(type)) continue;
            return "application/xhtml+xml";
        }
        return null;
    }

    public static boolean isHtmlContentType(String type) {
        return type.indexOf("html") != -1 || type.equals("*/*");
    }

    public static boolean isXmlContentType(String type) {
        return type.indexOf("xml") != -1;
    }
}

