/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.lang.reflect.Array;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.seasar.teeda.core.util.UIValueUtil;

public class ValueHolderUtil {
    public static String getValueForRender(FacesContext context, UIComponent component) {
        EditableValueHolder evh;
        Object submittedValue;
        if (!(component instanceof ValueHolder)) {
            throw new IllegalArgumentException("component must be ValueHolder");
        }
        if (component instanceof EditableValueHolder && (submittedValue = (evh = (EditableValueHolder)((Object)component)).getSubmittedValue()) != null) {
            if (submittedValue instanceof String) {
                return (String)submittedValue;
            }
            return submittedValue.toString();
        }
        ValueHolder vh = (ValueHolder)((Object)component);
        Object value = vh.getValue();
        Converter converter = vh.getConverter();
        return UIValueUtil.getValueAsString(context, component, value, converter);
    }

    public static String[] getValuesForRender(FacesContext context, UIComponent component) {
        EditableValueHolder evh;
        Object submittedValue;
        if (!(component instanceof ValueHolder)) {
            throw new IllegalArgumentException("component must be ValueHolder");
        }
        if (component instanceof EditableValueHolder && (submittedValue = (evh = (EditableValueHolder)((Object)component)).getSubmittedValue()) instanceof String[]) {
            return (String[])submittedValue;
        }
        ValueHolder vh = (ValueHolder)((Object)component);
        Object value = vh.getValue();
        if (value == null) {
            return new String[0];
        }
        Converter converter = vh.getConverter();
        int length = Array.getLength(value);
        String[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            values[i] = UIValueUtil.getValueAsString(context, component, Array.get(value, i), converter);
        }
        return values;
    }
}

