/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.facesdevfilter;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import jp.sf.pal.facesdevfilter.util.Enumerator;

public class ContainerInfo {
    public static final ResourceBundle CONTAINER_INFO = ResourceBundle.getBundle("jp.sf.pal.facesdevfilter.resources.ContainerInfo");

    public static final String getString(String name) {
        return CONTAINER_INFO.getString(name);
    }

    public static final Enumeration getKeys() {
        return CONTAINER_INFO.getKeys();
    }

    public static final String getPortletContainerName() {
        return ContainerInfo.getString("container.name");
    }

    public static final String getPortletContainerMajorVersion() {
        return ContainerInfo.getString("container.version.major");
    }

    public static final String getPortletContainerMinorVersion() {
        return ContainerInfo.getString("container.version.minor");
    }

    public static final int getMajorSpecificationVersion() {
        return Integer.parseInt(ContainerInfo.getString("javax.portlet.version.major"));
    }

    public static final int getMinorSpecificationVersion() {
        return Integer.parseInt(ContainerInfo.getString("javax.portlet.version.minor"));
    }

    public static final Enumeration getSupportedPortletModes() {
        String portletModes = ContainerInfo.getString("supported.portlet.modes");
        if (portletModes == null) {
            return null;
        }
        ArrayList<PortletMode> list = new ArrayList<PortletMode>();
        String[] modes = portletModes.split(",");
        for (int i = 0; i < modes.length; ++i) {
            list.add(new PortletMode(modes[i]));
        }
        return new Enumerator(list.iterator());
    }

    public static final Enumeration getSupportedWindowStates() {
        String windowStates = ContainerInfo.getString("supported.window.states");
        if (windowStates == null) {
            return null;
        }
        ArrayList<WindowState> list = new ArrayList<WindowState>();
        String[] states = windowStates.split(",");
        for (int i = 0; i < states.length; ++i) {
            list.add(new WindowState(states[i]));
        }
        return new Enumerator(list.iterator());
    }

    public static final String getServerInfo() {
        StringBuffer sb = new StringBuffer(ContainerInfo.getPortletContainerName()).append(ContainerInfo.getString("container.separator")).append(ContainerInfo.getPortletContainerMajorVersion()).append(".").append(ContainerInfo.getPortletContainerMinorVersion());
        return sb.toString();
    }
}

