/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.facesdevfilter;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sf.pal.facesdevfilter.FacesDevConstants;
import jp.sf.pal.facesdevfilter.http.HttpServletPortletRequestWrapper;
import jp.sf.pal.facesdevfilter.http.HttpServletPortletResponseWrapper;
import jp.sf.pal.facesdevfilter.portlet.PortletConfigImpl;
import jp.sf.pal.facesdevfilter.portlet.descriptors.PortletNode;
import jp.sf.pal.facesdevfilter.services.PortletConfigService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FacesDevFilter
implements Filter {
    private static final Log log = LogFactory.getLog((Class)FacesDevFilter.class);
    private static final String PORTLET_XML = "/WEB-INF/portlet.xml";
    public static final String ENCODING = "encoding";
    public static final String ADD_HTML_TAGS = "addHtmlTags";
    public static String DEFAULT_ENCODING = "UTF-8";
    private ServletContext servletContext;
    private PortletConfigService portletConfigService;
    private String encoding;
    private boolean addHtmlTags;

    public void init(FilterConfig filterConfig) throws ServletException {
        String v;
        this.servletContext = filterConfig.getServletContext();
        String portletXmlFilename = filterConfig.getServletContext().getRealPath(PORTLET_XML);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init(FilterConfig) - portletXmlFilename=" + portletXmlFilename));
        }
        try {
            this.portletConfigService = new PortletConfigService(new FileInputStream(portletXmlFilename));
        }
        catch (FileNotFoundException e) {
            log.error((Object)("File Not Found. The file name is " + portletXmlFilename), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        this.encoding = filterConfig.getInitParameter(ENCODING);
        if (this.encoding == null) {
            this.encoding = DEFAULT_ENCODING;
        }
        this.addHtmlTags = (v = filterConfig.getInitParameter(ADD_HTML_TAGS)) != null ? v.equalsIgnoreCase("true") : true;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletPortletRequestWrapper wrappedRequest = new HttpServletPortletRequestWrapper((HttpServletRequest)request, (HttpServletResponse)response);
            HttpServletPortletResponseWrapper wrappedResponse = new HttpServletPortletResponseWrapper((HttpServletRequest)request, (HttpServletResponse)response);
            this.storePortalEnvironment((HttpServletRequest)wrappedRequest, (HttpServletResponse)wrappedResponse);
            wrappedRequest.setAttribute("javax.portlet.PortletConfig", wrappedRequest.getSession().getAttribute("javax.portlet.PortletConfig"));
            chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
            this.postRender(wrappedResponse);
        } else {
            chain.doFilter(request, response);
        }
    }

    private void postRender(HttpServletPortletResponseWrapper wrappedResponse) throws IOException {
        StringBuffer buf;
        HttpServletResponse response = (HttpServletResponse)wrappedResponse.getResponse();
        PrintWriter writer = response.getWriter();
        if (this.addHtmlTags) {
            buf = new StringBuffer();
            buf.append("<html>");
            buf.append("<head>");
            buf.append("<meta http-equiv=\"Content-type\" content=\"text/html; charset=" + this.encoding + "\" />");
            buf.append("<title>Faces Development Filter</title>");
            buf.append("</head>");
            buf.append("<body>");
            ((Writer)writer).write(buf.toString());
        }
        ((Writer)writer).write(wrappedResponse.getString());
        if (this.addHtmlTags) {
            buf = new StringBuffer();
            buf.append("</body>");
            buf.append("</html>");
            ((Writer)writer).write(buf.toString());
        }
        ((Writer)writer).flush();
    }

    public void addHtmlFooter(ServletResponse response) {
        StringBuffer buf = new StringBuffer();
        buf.append("</body>");
        buf.append("</html>");
        try {
            response.getWriter().write(buf.toString());
            response.getWriter().flush();
        }
        catch (IOException e) {
            log.error((Object)"Could not add footer.", (Throwable)e);
        }
    }

    protected void storePortalEnvironment(HttpServletRequest request, HttpServletResponse response) {
        String namespaceName;
        String windowStateName;
        String portletModeName;
        PortletNode portletNode;
        HttpSession session = request.getSession(true);
        String portletName = request.getParameter("portletname");
        if (portletName == null) {
            if (session.getAttribute("javax.portlet.PortletConfig") == null) {
                portletNode = this.portletConfigService.getDefaultPortlet();
                if (portletNode == null) {
                    throw new IllegalArgumentException("Could not find a default portlet in the portlet descriptor. ");
                }
                PortletConfigImpl portletConfig = new PortletConfigImpl(this.servletContext, portletNode);
                session.setAttribute("javax.portlet.PortletConfig", (Object)portletConfig);
                String portletClassName = portletNode.getPortletClass();
                Portlet portlet = this.createPortlet(portletClassName, portletConfig);
                session.setAttribute(FacesDevConstants.PORTLET, (Object)portlet);
            }
        } else {
            portletNode = this.portletConfigService.getPortletByName(portletName);
            if (portletNode == null) {
                throw new IllegalArgumentException("Could not find " + portletName + " in the portlet descriptor. ");
            }
            PortletNode prevPortletNode = (PortletNode)session.getAttribute("javax.portlet.PortletConfig");
            if (!portletNode.equals(prevPortletNode)) {
                PortletConfigImpl portletConfig = new PortletConfigImpl(this.servletContext, portletNode);
                session.setAttribute("javax.portlet.PortletConfig", (Object)portletConfig);
                Portlet prevPortlet = (Portlet)session.getAttribute(FacesDevConstants.PORTLET);
                if (prevPortlet != null) {
                    prevPortlet.destroy();
                }
                String portletClassName = portletNode.getPortletClass();
                Portlet portlet = this.createPortlet(portletClassName, portletConfig);
                session.setAttribute(FacesDevConstants.PORTLET, (Object)portlet);
            }
        }
        if ((portletModeName = request.getParameter("portletmode")) == null) {
            if (session.getAttribute(FacesDevConstants.PORTLET_MODE) == null) {
                session.setAttribute(FacesDevConstants.PORTLET_MODE, (Object)new PortletMode("view"));
            }
        } else {
            session.setAttribute(FacesDevConstants.PORTLET_MODE, (Object)new PortletMode(portletModeName));
        }
        if ((windowStateName = request.getParameter("windowstate")) == null) {
            if (session.getAttribute(FacesDevConstants.WINDOW_STATE) == null) {
                session.setAttribute(FacesDevConstants.WINDOW_STATE, (Object)new WindowState("normal"));
            }
        } else {
            session.setAttribute(FacesDevConstants.WINDOW_STATE, (Object)new WindowState(windowStateName));
        }
        if ((namespaceName = request.getParameter("namespace")) == null) {
            if (session.getAttribute(FacesDevConstants.NAMESPACE) == null) {
                session.setAttribute(FacesDevConstants.NAMESPACE, (Object)"");
            }
        } else {
            session.setAttribute(FacesDevConstants.NAMESPACE, (Object)namespaceName);
        }
    }

    private Portlet createPortlet(String portletClassName, PortletConfig portletConfig) {
        try {
            Class<?> portletClass = Class.forName(portletClassName);
            Object portletObj = portletClass.newInstance();
            if (portletObj instanceof Portlet) {
                Portlet portlet = (Portlet)portletObj;
                portlet.init(portletConfig);
                return portlet;
            }
            throw new IllegalArgumentException(portletClassName + " is not Portlet instance.");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(portletClassName + " is not Portlet instance.", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(portletClassName + " is not Portlet instance.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(portletClassName + " is not Portlet instance.", e);
        }
        catch (PortletException e) {
            throw new IllegalStateException("An exception occurrs during calling init() in " + portletClassName, e);
        }
    }
}

