/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.facesdevfilter.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jp.sf.pal.facesdevfilter.FacesDevConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpServletPortletResponseWrapper
extends HttpServletResponseWrapper
implements PortletResponse,
ActionResponse,
RenderResponse {
    private static final Log log = LogFactory.getLog((Class)HttpServletPortletResponseWrapper.class);
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String currentContentType;
    private ByteArrayOutputStream outputStream = null;
    private PrintWriter printWriter = null;

    public HttpServletPortletResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this.request = request;
        this.response = response;
        this.outputStream = new ByteArrayOutputStream();
    }

    public byte[] getBytes() {
        return this.outputStream.toByteArray();
    }

    public String getString() {
        try {
            if (this.printWriter != null) {
                this.printWriter.flush();
            }
            this.outputStream.flush();
        }
        catch (IOException e) {
            log.warn((Object)"Could not flush the output stream.", (Throwable)e);
        }
        try {
            return this.outputStream.toString(this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)("Unsupported encoding: " + this.getCharacterEncoding()), (Throwable)e);
            return this.outputStream.toString();
        }
    }

    public PrintWriter getWriter() {
        if (this.printWriter == null) {
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)this.outputStream, Charset.forName(this.getCharacterEncoding()));
            this.printWriter = new PrintWriter((Writer)streamWriter, true);
        }
        return this.printWriter;
    }

    public ServletOutputStream getOutputStream() {
        return new ServletOutputStreamWrapper(this.outputStream);
    }

    public void setContentLength(int contentLength) {
    }

    public void flushBuffer() throws IOException {
        this.outputStream.flush();
    }

    public void finishResponse() {
        try {
            if (this.printWriter != null) {
                this.printWriter.close();
            } else if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"I/O exception.", (Throwable)e);
        }
    }

    public void setContentType(String contentType) {
        super.setContentType(contentType);
        this.currentContentType = contentType;
    }

    public void addProperty(String arg0, String arg1) {
    }

    public void setProperty(String arg0, String arg1) {
    }

    public void setPortletMode(PortletMode mode) throws PortletModeException {
        this.request.getSession().setAttribute(FacesDevConstants.PORTLET_MODE, (Object)mode);
    }

    public void setRenderParameter(String arg0, String arg1) {
    }

    public void setRenderParameter(String arg0, String[] arg1) {
    }

    public void setRenderParameters(Map arg0) {
    }

    public void setWindowState(WindowState state) throws WindowStateException {
        this.request.getSession().setAttribute(FacesDevConstants.WINDOW_STATE, (Object)state);
    }

    public PortletURL createActionURL() {
        return null;
    }

    public PortletURL createRenderURL() {
        return null;
    }

    public String getContentType() {
        return this.currentContentType;
    }

    public String getNamespace() {
        return (String)this.request.getSession().getAttribute(FacesDevConstants.NAMESPACE);
    }

    public OutputStream getPortletOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public void setTitle(String title) {
        this.request.setAttribute(FacesDevConstants.PORTLET_TITLE, (Object)title);
    }

    private class ServletOutputStreamWrapper
    extends ServletOutputStream {
        private ByteArrayOutputStream outputStream_;

        public ServletOutputStreamWrapper(ByteArrayOutputStream outputStream) {
            this.outputStream_ = outputStream;
        }

        public void write(int b) {
            this.outputStream_.write(b);
        }

        public void write(byte[] bytes) throws IOException {
            this.outputStream_.write(bytes);
        }

        public void write(byte[] bytes, int off, int len) {
            this.outputStream_.write(bytes, off, len);
        }
    }
}

