/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.facesdevfilter.portlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import javax.servlet.http.HttpSession;
import jp.sf.pal.facesdevfilter.util.Enumerator;

public class PortletPreferencesImpl
implements PortletPreferences {
    private static final String PREFERENCE_MAP = "PREFERENCE_MAP";
    private HttpSession httpSession;
    private Map preferenceMap;

    public PortletPreferencesImpl(HttpSession httpSession) {
        this.httpSession = httpSession;
        this.resetPreferences();
    }

    private void resetPreferences() {
        this.preferenceMap = new HashMap();
        Map prefMap = (Map)this.httpSession.getAttribute(PREFERENCE_MAP);
        if (prefMap != null) {
            prefMap.putAll(this.preferenceMap);
        }
    }

    public Map getMap() {
        return this.preferenceMap;
    }

    public Enumeration getNames() {
        return new Enumerator(this.preferenceMap.keySet().iterator());
    }

    public String getValue(String key, String defaultValue) {
        String value = (String)this.preferenceMap.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getValues(String key, String[] defaultValues) {
        String[] values = (String[])this.preferenceMap.get(key);
        if (values == null) {
            values = defaultValues;
        }
        return values;
    }

    public boolean isReadOnly(String key) {
        return false;
    }

    public void reset(String key) throws ReadOnlyException {
        this.preferenceMap.remove(key);
    }

    public void setValue(String key, String value) throws ReadOnlyException {
        this.preferenceMap.put(key, value);
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        this.preferenceMap.put(key, values);
    }

    public void store() throws IOException, ValidatorException {
        this.httpSession.setAttribute(PREFERENCE_MAP, (Object)this.preferenceMap);
        this.resetPreferences();
    }
}

