/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.facesdevfilter.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletMode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.sf.pal.facesdevfilter.portlet.descriptors.PortletInfoNode;
import jp.sf.pal.facesdevfilter.portlet.descriptors.PortletNode;
import jp.sf.pal.facesdevfilter.portlet.descriptors.RoleRefNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PortletConfigService {
    private static final Log log = LogFactory.getLog((Class)PortletConfigService.class);
    private Document _doc;
    private List portletList;

    private PortletConfigService() {
    }

    public PortletConfigService(InputStream ios) {
        this._doc = this.getDocument(ios);
        this.createPortletDDList();
    }

    private Document getDocument(InputStream ios) {
        boolean validation = false;
        boolean ignoreWhitespace = false;
        boolean ignoreComments = false;
        boolean putCDATAIntoText = false;
        boolean createEntityRefs = false;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validation);
        dbf.setIgnoringComments(ignoreComments);
        dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
        dbf.setCoalescing(putCDATAIntoText);
        dbf.setExpandEntityReferences(!createEntityRefs);
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = dbf.newDocumentBuilder();
            doc = db.parse(ios);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Parser Configuration Exception.", (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"SAX Exception.", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"I/O Exception.", (Throwable)e);
        }
        return doc;
    }

    private void createPortletDDList() {
        this.portletList = new ArrayList();
        NodeList portlets = this._doc.getElementsByTagName("portlet");
        Element portlet = null;
        NodeList roleRefs = null;
        ArrayList<RoleRefNode> refList = null;
        Element ref = null;
        if (portlets != null) {
            for (int i = 0; i < portlets.getLength(); ++i) {
                int j;
                IllegalStateException e;
                PortletNode portletEntry = new PortletNode();
                portlet = (Element)portlets.item(i);
                if (portlet.getElementsByTagName("portlet-name").item(0) != null) {
                    String name = portlet.getElementsByTagName("portlet-name").item(0).getChildNodes().item(0).getNodeValue();
                    if (name == null) {
                        e = new IllegalStateException("The portlet-name element is required in portlet.xml");
                        log.error((Object)e);
                        throw e;
                    }
                    portletEntry.setPortletName(name);
                }
                if (portlet.getElementsByTagName("portlet-class").item(0) != null) {
                    String className = portlet.getElementsByTagName("portlet-class").item(0).getChildNodes().item(0).getNodeValue();
                    if (className == null) {
                        e = new IllegalStateException("The portlet-class element is required in portlet.xml");
                        log.error((Object)e);
                        throw e;
                    }
                    portletEntry.setPortletClass(className);
                }
                NodeList initParams = portlet.getElementsByTagName("init-param");
                HashMap<String, String> initParamMap = new HashMap<String, String>();
                if (initParams != null) {
                    for (j = 0; j < initParams.getLength(); ++j) {
                        Element initParam = (Element)initParams.item(j);
                        if (initParam.getElementsByTagName("name") == null || initParam.getElementsByTagName("value") == null) continue;
                        String n = initParam.getElementsByTagName("name").item(0).getChildNodes().item(0).getNodeValue();
                        String v = initParam.getElementsByTagName("value").item(0).getChildNodes().item(0).getNodeValue();
                        if (n == null || v == null) continue;
                        initParamMap.put(n, v);
                    }
                }
                portletEntry.setInitParams(initParamMap);
                if (portlet.getElementsByTagName("supports").item(0) != null) {
                    Element supports = (Element)portlet.getElementsByTagName("supports").item(0);
                    ArrayList<String> mimeTypeList = new ArrayList<String>();
                    NodeList mimeTypes = supports.getElementsByTagName("mime-type");
                    if (mimeTypes != null) {
                        for (int j2 = 0; j2 < mimeTypes.getLength(); ++j2) {
                            mimeTypeList.add(mimeTypes.item(j2).getChildNodes().item(0).getNodeValue());
                        }
                    } else {
                        mimeTypeList.add("text/html");
                    }
                    portletEntry.setMimeTypes(mimeTypeList);
                    ArrayList<PortletMode> portletModeList = new ArrayList<PortletMode>();
                    NodeList portletModes = supports.getElementsByTagName("portlet-mode");
                    if (portletModes != null) {
                        for (int j3 = 0; j3 < portletModes.getLength(); ++j3) {
                            portletModeList.add(new PortletMode(portletModes.item(j3).getChildNodes().item(0).getNodeValue().toLowerCase()));
                        }
                    } else {
                        portletModeList.add(new PortletMode("view"));
                    }
                    portletEntry.setPortletModes(portletModeList);
                }
                if (portlet.getElementsByTagName("resource-bundle").item(0) != null) {
                    String resourceBundle = portlet.getElementsByTagName("resource-bundle").item(0).getChildNodes().item(0).getNodeValue();
                    portletEntry.setResourceBundle(resourceBundle);
                }
                if (portlet.getElementsByTagName("portlet-info").item(0) != null) {
                    Element portletInfo = (Element)portlet.getElementsByTagName("portlet-info").item(0);
                    String title = null;
                    String shortTitle = null;
                    String keywords = null;
                    if (portletInfo.getElementsByTagName("title").item(0) != null) {
                        title = portletInfo.getElementsByTagName("title").item(0).getChildNodes().item(0).getNodeValue();
                    }
                    if (portletInfo.getElementsByTagName("short-title").item(0) != null) {
                        shortTitle = portletInfo.getElementsByTagName("short-title").item(0).getChildNodes().item(0).getNodeValue();
                    }
                    if (portletInfo.getElementsByTagName("keywords").item(0) != null) {
                        keywords = portletInfo.getElementsByTagName("keywords").item(0).getChildNodes().item(0).getNodeValue();
                    }
                    if (title != null || shortTitle != null || keywords != null) {
                        PortletInfoNode portletInfoEntry = new PortletInfoNode();
                        portletInfoEntry.setTitle(title);
                        portletInfoEntry.setShortTitle(shortTitle);
                        portletInfoEntry.setKeywords(keywords);
                        portletEntry.setPortletInfo(portletInfoEntry);
                    }
                }
                roleRefs = portlet.getElementsByTagName("security-role-ref");
                refList = new ArrayList<RoleRefNode>();
                if (roleRefs != null && roleRefs.getLength() != 0) {
                    for (j = 0; j < roleRefs.getLength(); ++j) {
                        ref = (Element)roleRefs.item(j);
                        String refName = ref.getElementsByTagName("role-name").item(0).getChildNodes().item(0).getNodeValue();
                        String refLink = null;
                        if (ref.getElementsByTagName("role-link").item(0) != null) {
                            refLink = ref.getElementsByTagName("role-link").item(0).getChildNodes().item(0).getNodeValue();
                        }
                        refList.add(new RoleRefNode(refName, refLink));
                    }
                }
                portletEntry.setSecurityRoleRefs(refList);
                this.portletList.add(portletEntry);
            }
        } else {
            IllegalStateException e = new IllegalStateException("The portlet.xml file does not contain portlet elements.");
            log.error((Object)e);
            throw e;
        }
    }

    public List getPortletList() {
        return this.portletList;
    }

    public PortletNode getPortletByName(String name) {
        if (name == null) {
            return null;
        }
        Iterator ite = this.getPortletList().iterator();
        while (ite.hasNext()) {
            PortletNode portlet = (PortletNode)ite.next();
            if (!name.equals(portlet.getPortletName())) continue;
            return portlet;
        }
        return null;
    }

    public PortletNode getDefaultPortlet() {
        if (this.getPortletList() == null || this.getPortletList().size() == 0) {
            throw new IllegalStateException("Could not find a portlet in the portlet descriptor.");
        }
        return (PortletNode)this.getPortletList().get(0);
    }
}

