/*
 * Copyright 2005-2006 Portal Application Laboratory project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.facesdevfilter.portlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;

import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import javax.servlet.ServletContext;

import jp.sf.pal.facesdevfilter.ContainerInfo;

/**
 * @author shinsuke
 * 
 */
public class PortletContextImpl implements PortletContext {
    private ServletContext servletContext;

    public PortletContextImpl(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getAttribute(java.lang.String)
     */
    public Object getAttribute(String name) {
        return servletContext.getAttribute(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getAttributeNames()
     */
    public Enumeration getAttributeNames() {
        return servletContext.getAttributeNames();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getInitParameter(java.lang.String)
     */
    public String getInitParameter(String name) {
        return servletContext.getInitParameter(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getInitParameterNames()
     */
    public Enumeration getInitParameterNames() {
        return servletContext.getInitParameterNames();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getMajorVersion()
     */
    public int getMajorVersion() {
        return ContainerInfo.getMajorSpecificationVersion();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getMimeType(java.lang.String)
     */
    public String getMimeType(String file) {
        return servletContext.getMimeType(file);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getMinorVersion()
     */
    public int getMinorVersion() {
        return ContainerInfo.getMinorSpecificationVersion();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getNamedDispatcher(java.lang.String)
     */
    public PortletRequestDispatcher getNamedDispatcher(String arg0) {
        // TODO is it needed??
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getPortletContextName()
     */
    public String getPortletContextName() {
        return servletContext.getServletContextName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getRealPath(java.lang.String)
     */
    public String getRealPath(String path) {
        return servletContext.getRealPath(path);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getRequestDispatcher(java.lang.String)
     */
    public PortletRequestDispatcher getRequestDispatcher(String arg0) {
        // TODO is it needed??
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getResource(java.lang.String)
     */
    public URL getResource(String path) throws MalformedURLException {
        return servletContext.getResource(path);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getResourceAsStream(java.lang.String)
     */
    public InputStream getResourceAsStream(String path) {
        return servletContext.getResourceAsStream(path);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getResourcePaths(java.lang.String)
     */
    public Set getResourcePaths(String arg0) {
        return servletContext.getResourcePaths(arg0);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#getServerInfo()
     */
    public String getServerInfo() {
        return servletContext.getServerInfo();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#log(java.lang.String)
     */
    public void log(String msg) {
        servletContext.log(msg);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#log(java.lang.String,
     *      java.lang.Throwable)
     */
    public void log(String message, Throwable throwable) {
        servletContext.log(message, throwable);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#removeAttribute(java.lang.String)
     */
    public void removeAttribute(String name) {
        servletContext.removeAttribute(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletContext#setAttribute(java.lang.String,
     *      java.lang.Object)
     */
    public void setAttribute(String name, Object object) {
        servletContext.setAttribute(name, object);
    }

}
