/*
 * Copyright 2005-2006 Portal Application Laboratory project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.facesdevfilter.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public class Enumerator implements Enumeration {
    private Iterator iterator = null;

    /**
     * Returns an Enumeration over the specified Collection.
     * 
     * @param collection
     *            Collection with values that should be enumerated
     */
    public Enumerator(Collection collection) {
        this(collection.iterator());
    }

    /**
     * Returns an Enumeration over the values of the specified Iterator.
     * 
     * @param iterator
     *            Iterator to be wrapped
     */
    public Enumerator(Iterator iterator) {
        super();
        this.iterator = iterator;
    }

    /**
     * Returns an Enumeration over the values of the specified Map.
     * 
     * @param map
     *            Map with values that should be enumerated
     */
    public Enumerator(Map map) {
        this(map.values().iterator());
    }

    public boolean hasMoreElements() {
        return iterator.hasNext();
    }

    public Object nextElement() {
        return iterator.next();
    }

}
