package jp.sf.pal.jstock.ajax;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;

import jp.sf.pal.jstock.reader.StockDataReader;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.teeda.ajax.AjaxUtil;
import org.xml.sax.SAXException;

public class StockDataAjax {
    
    private static final String PATH = "jp/sf/pal/jstock/jstock.dicon";
    
    private List stockDataList;
    
    public StockDataAjax() {
        
        S2Container container = SingletonS2ContainerFactory.getContainer();
        
        StockDataReader reader = (StockDataReader) container.getComponent("reader");
        List codeList = (List)container.getComponent("codeList");
        
        reader.setCodes(codeList);
        this.stockDataList = reader.getStockDataList();

    }

    /**
     * JSON 文字列を返す
     * @return
     */
    private String createJson() {
        
        StringBuffer buf = new StringBuffer();
        buf.append(AjaxUtil.toJson(this.stockDataList));
        
        return buf.toString();
        
    }
    
    public String getStockData() {
        return createJson();
    }

}
